package tools.redstone.redstonetools.features.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_5134;
import net.minecraft.class_7157;


public class ReachFeature {
	public static final ReachFeature INSTANCE = new ReachFeature();

	protected ReachFeature() {
	}

	public void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 registrationEnvironment) {
			dispatcher.register(class_2170.method_9247("reach")
				.requires(source -> source.method_9259(2))
				.then(class_2170.method_9244("reach", FloatArgumentType.floatArg(0.0f))
					.executes(context -> execute(context, true, true))
				)
				.then(class_2170.method_9247("reset")
					.executes(context -> reset(context, true, true))
				)
				.then(class_2170.method_9247("block")
					.then(class_2170.method_9244("reach", FloatArgumentType.floatArg(0.0f))
						.suggests((context, builder) -> {
							builder.suggest(String.valueOf(class_5134.field_47758.comp_349().method_6169()));
							return builder.buildFuture();
						})
						.executes(context -> execute(context, true, false))
					)
				)
				.then(class_2170.method_9247("entity")
					.then(class_2170.method_9244("reach", FloatArgumentType.floatArg(0.0f))
						.suggests((context, builder) -> {
							builder.suggest(String.valueOf(class_5134.field_47759.comp_349().method_6169()));
							return builder.buildFuture();
						})
						.executes(context -> execute(context, false, true))
					)
				));
	}

	private int execute(CommandContext<class_2168> context, boolean block, boolean entity) throws CommandSyntaxException {
		String playerName = context.getSource().method_9207().method_5477().getString();
		float reach = FloatArgumentType.getFloat(context, "reach");
		if (block) context.getSource().method_9211().method_3734().method_44252(context.getSource(), "/attribute " + playerName + " minecraft:block_interaction_range base set " + reach);
		if (entity) context.getSource().method_9211().method_3734().method_44252(context.getSource(), "/attribute " + playerName + " minecraft:entity_interaction_range base set " + reach);
		return 0;
	}

	private int reset(CommandContext<class_2168> context, boolean block, boolean entity) throws CommandSyntaxException {
		String playerName = context.getSource().method_9207().method_5477().getString();
		if (block) context.getSource().method_9211().method_3734().method_44252(context.getSource(), "/attribute " + playerName + " minecraft:block_interaction_range base reset");
		if (entity) context.getSource().method_9211().method_3734().method_44252(context.getSource(), "/attribute " + playerName + " minecraft:entity_interaction_range base reset");
		return 0;
	}
}
