package tools.redstone.redstonetools.features.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import tools.redstone.redstonetools.utils.ArgumentUtils;
import tools.redstone.redstonetools.utils.SignalBlock;

import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class SignalStrengthBlockFeature {
	public static final SignalStrengthBlockFeature INSTANCE = new SignalStrengthBlockFeature();

	protected SignalStrengthBlockFeature() {
	}

	public void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 registrationEnvironment) {
			dispatcher.register(method_9247("ssb")
				.requires(source -> source.method_9259(2))
				.executes(this::parseArguments)
				.then(method_9244("signalStrength", IntegerArgumentType.integer())
						.executes(this::parseArguments)
						.then(method_9244("block", StringArgumentType.string()).suggests(ArgumentUtils.SIGNAL_BLOCK_SUGGESTION_PROVIDER)
								.executes(this::parseArguments))));
	}

	protected int parseArguments(CommandContext<class_2168> context) throws CommandSyntaxException {
		int signalStrength;
		SignalBlock block;
		try {
			signalStrength = IntegerArgumentType.getInteger(context, "signalStrength");
		} catch (Exception ignored) {
			signalStrength = 15;
		}
		try {
			block = ArgumentUtils.parseSignalBlock(context, "block");
		} catch (Exception ignored) {
			block = SignalBlock.AUTO;
		}
		return execute(context, signalStrength, block);
	}

	protected int execute(CommandContext<class_2168> context, int signalStrength, SignalBlock block) throws CommandSyntaxException {
		try {
			var playerInventory = Objects.requireNonNull(context.getSource().method_44023()).method_31548();
			class_1799 itemStack = block.getItemStack(signalStrength);
			playerInventory.method_7394(itemStack);
//			playerInventory.swapStackWithHotbar(itemStack);
		} catch (IllegalArgumentException | IllegalStateException | NullPointerException e) {
			throw new SimpleCommandExceptionType(class_2561.method_43470(e.getMessage())).create();
		}

		// who intentionally doesnt put a space between the last / and the message??
		//funny
		if (signalStrength == 0) {
			String[] funny = {
					"Why would you want this??", "Wtf are you going to use this for?", "What for?",
					"... Ok, if you're sure.", "I'm 99% sure you could just use any other block.",
					"This seems unnecessary.", "Is that a typo?", "Do you just like the glint?",
					"Wow, what a fancy but otherwise useless " + block.name().toLowerCase(Locale.ROOT).replace("_", " ") + "."
					, "For decoration?"};
			context.getSource().method_45068(class_2561.method_43470(funny[new Random().nextInt(funny.length)]));
			return 1;
		}

		return 1;
	}

}
