package tools.redstone.redstonetools.features.toggleable;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

import static net.minecraft.class_2170.method_9247;

public class ClickContainerFeature extends ToggleableFeature {
	public static final ClickContainerFeature INSTANCE = new ClickContainerFeature();

	protected ClickContainerFeature() {
	}

	private static long lasttime = -1;

	static {
		UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
			if (world == null) return class_1269.field_5811;
			if (world.field_9236) return class_1269.field_5811;
			if (!ClickContainerFeature.INSTANCE.isEnabled((class_3222) player)) return class_1269.field_5811;

			class_1799 stack = player.method_5998(hand);
			if (!stack.method_7960() ||
			stack.method_7909() instanceof class_1747) return class_1269.field_5811;

			class_2338 pos = hitResult.method_17777();
			class_2680 state = world.method_8320(pos);

			if (world.method_8510() == lasttime) {
				return class_1269.field_5811;
			}
			lasttime = world.method_8510();

			if (state.method_27852(class_2246.field_27097) || state.method_27852(class_2246.field_27098) || state.method_27852(class_2246.field_27878)) {
				if (state.method_28498(class_2741.field_12513)) {
					handleIntLevelProperty(world, pos, state, class_2741.field_12513, class_2246.field_10593, (class_3222) player);
					return class_1269.field_5812;
				}
			}

			if (state.method_27852(class_2246.field_10593)) {
				class_2680 newState = class_2246.field_27097.method_9564().method_11657(class_2741.field_12513, 1);
				world.method_8501(pos, newState);
				return class_1269.field_5812;
			}

			if (state.method_27852(class_2246.field_17563)) {
				handleIntLevelProperty(world, pos, state, class_2741.field_17586, class_2246.field_17563, (class_3222) player);
				return class_1269.field_5812;
			}

			return class_1269.field_5811;
		});
	}

	public static void handleIntLevelProperty(class_1937 world, class_2338 pos, class_2680 state, class_2758 prop, net.minecraft.class_2248 resetBlock, class_3222 player) {
		if (prop == null) return;
		Integer current;
		try {
			current = state.method_11654(prop);
		} catch (Exception e) {
			System.err.println("[ClickContainerFeature] Failed to read property " + prop.method_11899() + " for block " + state.method_26204() + " at " + pos + ": " + e);
			return;
		}
		if (current == null) return;

		int max = prop.method_11898().stream().max(Integer::compareTo).orElse(current);

		if (current >= max) {
			world.method_8501(pos, resetBlock.method_9564());
			return;
		}

		int next = current + 1;
		world.method_8652(pos, state.method_11657(prop, next), 3);

		player.method_64398(class_2561.method_30163("§2[ClickContainers] §6Increased level!"));
	}

	public void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 registrationEnvironment) {
			dispatcher.register(method_9247("clickcontainers").executes(this::toggle));
	}

	@Override
	public String getName() {
		return "ClickContainers";
	}
}
