package tools.redstone.redstonetools.features.toggleable;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import tools.redstone.redstonetools.packets.SetFeatureEnabledPayload;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public abstract class ToggleableFeature {
	private final Set<UUID> enabledFor = new HashSet<>(); // volatile for thread safety

	public boolean isEnabled(class_3222 player) {
		return enabledFor.contains(player.method_5667());
	}

	public int toggle(CommandContext<class_2168> context) throws CommandSyntaxException {
		return toggle(context.getSource());
	}

	public int toggle(class_2168 source) throws CommandSyntaxException {
		class_3222 player = source.method_9207();
		return !enabledFor.contains(player.method_5667()) ? enable(source) : disable(source);
	}

	public void setEnabled(boolean status, class_3222 player) {
		if (status) {
			enable(player);
		} else {
			disable(player);
		}
	}

	public void enable(class_3222 player) {
		enabledFor.add(player.method_5667());
		var payload = new SetFeatureEnabledPayload(this.getName(), true);
		ServerPlayNetworking.send(player, payload);
		onEnable();
	}

	public int enable(class_2168 source) throws CommandSyntaxException {
		enable(source.method_9207());
		source.method_45068(class_2561.method_43470("Enabled " + this.getName()));
		return 0;
	}

	public void disable(class_3222 player) {
		enabledFor.remove(player.method_5667());
		var payload = new SetFeatureEnabledPayload(this.getName(), false);
		ServerPlayNetworking.send(player, payload);
		onDisable();
	}

	public int disable(class_2168 source) throws CommandSyntaxException {
		disable(source.method_9207());
		source.method_45068(class_2561.method_43470("Disabled " + this.getName()));
		return 0;
	}

	public abstract String getName();

	protected void onEnable() {
	}

	protected void onDisable() {
	}
}
