package tools.redstone.redstonetools.malilib;

import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiKeybindSettings;
import fi.dy.masa.malilib.gui.button.ConfigButtonBoolean;
import fi.dy.masa.malilib.gui.button.ConfigButtonKeybind;
import fi.dy.masa.malilib.gui.widgets.WidgetKeybindSettings;
import tools.redstone.redstonetools.malilib.config.MacroManager;
import tools.redstone.redstonetools.malilib.widget.action.CommandListWidget;
import tools.redstone.redstonetools.malilib.widget.macro.MacroBase;
import tools.redstone.redstonetools.utils.GuiUtils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class GuiMacroEditor extends class_437 {
	public final MacroBase macro;
	private final GuiMacroManager parent;
	private CommandListWidget commandList;
	private ConfigButtonKeybind buttonKeybind;
	private ConfigButtonBoolean buttonEnabled;
	private ConfigButtonBoolean buttonMuted;
	private WidgetKeybindSettings widgetAdvancedKeybindSettings;
	private IConfigBoolean configBoolean;
	private IConfigBoolean configBoolean2;
	public class_342 nameWidget;
	private float errorCountDown;

	public GuiMacroEditor(class_2561 title, MacroBase macro, GuiMacroManager parent) {
		super(title);
		this.parent = parent;
		this.field_22787 = class_310.method_1551();
		this.macro = macro;
	}

	private static Method bkRenderMethod;
	private static Method beRenderMethod;
	private static Method bmRenderMethod;
	private static Method waksRenderMethod;


	@Override
	public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
		super.method_25394(context, mouseX, mouseY, deltaTicks);
		buttonKeybind.updateDisplayString();
		buttonEnabled.updateDisplayString();
		buttonMuted.updateDisplayString();
		try {
			buttonKeybind.render(context, mouseX, mouseY, buttonKeybind.isMouseOver(mouseX, mouseY));
			buttonEnabled.render(context, mouseX, mouseY, buttonEnabled.isMouseOver(mouseX, mouseY));
			buttonMuted.render(context, mouseX, mouseY, buttonMuted.isMouseOver(mouseX, mouseY));
			widgetAdvancedKeybindSettings.render(context, mouseX, mouseY, widgetAdvancedKeybindSettings.isMouseOver(mouseX, mouseY));
		} catch (NoSuchMethodError ignored) {
			if (bkRenderMethod == null) {
				try {
					bkRenderMethod = ConfigButtonKeybind.class.getMethod("render", int.class, int.class, boolean.class, class_332.class);
					beRenderMethod = ConfigButtonBoolean.class.getMethod("render", int.class, int.class, boolean.class, class_332.class);
					bmRenderMethod = ConfigButtonBoolean.class.getMethod("render", int.class, int.class, boolean.class, class_332.class);
					waksRenderMethod = WidgetKeybindSettings.class.getMethod("render", int.class, int.class, boolean.class, class_332.class);
				} catch (Exception e) {
					throw new RuntimeException("Something went wrong. Contact a redstonetools developer", e);
				}
			}
			try {
				bkRenderMethod.invoke(buttonKeybind, mouseX, mouseY, buttonKeybind.isMouseOver(mouseX, mouseY), context);
				beRenderMethod.invoke(buttonEnabled, mouseX, mouseY, buttonEnabled.isMouseOver(mouseX, mouseY), context);
				bmRenderMethod.invoke(buttonMuted, mouseX, mouseY, buttonMuted.isMouseOver(mouseX, mouseY), context);
				waksRenderMethod.invoke(widgetAdvancedKeybindSettings, mouseX, mouseY, widgetAdvancedKeybindSettings.isMouseOver(mouseX, mouseY), context);
			} catch (IllegalAccessException | InvocationTargetException e) {
				throw new RuntimeException("Something went wrong. Contact a redstonetools developer", e);
			}
		}
		if (errorCountDown > 0.0f) {
			context.method_51433(this.field_22793, "Name already exists!", mouseX, mouseY - 10, 0xFFFFFFFF, true);
			errorCountDown -= deltaTicks;
		}
	}

	@Override
	protected void method_25426() {
		List<GuiUtils.MinMaxLayout> minMaxLayouts = new ArrayList<>();
		minMaxLayouts.add(new GuiUtils.MinMaxLayout(-1, -1, -1, -1)); // new command
		minMaxLayouts.add(new GuiUtils.MinMaxLayout(-1, -1, -1, -1)); // button keybind
		minMaxLayouts.add(new GuiUtils.MinMaxLayout(-1, 20, -1, -1)); // advanced keybinds option
		minMaxLayouts.add(new GuiUtils.MinMaxLayout(-1, -1, -1, -1)); // button enabled
		minMaxLayouts.add(new GuiUtils.MinMaxLayout(-1, -1, -1, -1)); // name widget
		minMaxLayouts.add(new GuiUtils.MinMaxLayout(-1, -1, -1, -1)); // mute
		List<GuiUtils.Layout> layouts = GuiUtils.betterGetWidgetLayout(minMaxLayouts, 10, this.field_22789, true, 50, this.field_22790 - 52, 20);
		GuiUtils.Layout ncLayout = layouts.get(0);
		GuiUtils.Layout bkLayout = layouts.get(1);
		GuiUtils.Layout akoLayout = layouts.get(2);
		GuiUtils.Layout beLayout = layouts.get(3);
		GuiUtils.Layout nwLayout = layouts.get(4);
		GuiUtils.Layout bmLayout = layouts.get(5);
		this.commandList = this.method_37063(
			new CommandListWidget(this, this.field_22787, this.field_22789, this.field_22790 - 75, 0, 36, this.macro));
		this.method_37063(class_4185.method_46430(class_2561.method_30163("Add command"), button ->
				this.commandList.addEntry())
			.method_46434(ncLayout.x(), ncLayout.y(), ncLayout.width(), ncLayout.height())
			.method_46431());
		this.widgetAdvancedKeybindSettings = new WidgetKeybindSettings(akoLayout.x(), akoLayout.y(), akoLayout.width(), akoLayout.height(), macro.hotkey.getKeybind(), "", null, null) {
			@Override
			protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
				if (mouseButton == 0) {
					GuiBase.openGui(new GuiKeybindSettings(this.keybind, this.keybindName, null, fi.dy.masa.malilib.util.GuiUtils.getCurrentScreen()));
					return true;
				} else return super.onMouseClickedImpl(mouseX, mouseY, mouseButton);
			}
		};
		this.buttonKeybind = new ConfigButtonKeybind(bkLayout.x(), bkLayout.y(), bkLayout.width(), bkLayout.height(), macro.hotkey.getKeybind(), null) {
			@Override
			public boolean onMouseClicked(int mx, int my, int mb) {
				if (!this.isMouseOver(mx, my)) {
					this.selected = false;
					return false;
				} else {
					return super.onMouseClicked(mx, my, mb);
				}
			}
			@Override
			public void onClearSelection() {
				this.firstKey = true;
				super.onClearSelection();
			}
		};
		this.configBoolean = new ConfigBoolean("", true, "");
		this.configBoolean.setBooleanValue(this.macro.isEnabled());
		this.configBoolean2 = new ConfigBoolean("", true, "");
		this.configBoolean2.setBooleanValue(this.macro.muted);
		final String beName = "Enabled: ";
		final String bmName = "Muted: ";
		this.buttonEnabled = new ConfigButtonBoolean(beLayout.x(), beLayout.y(), beLayout.width(), beLayout.height(), this.configBoolean) {
			@Override
			public void updateDisplayString() {
				super.updateDisplayString();
				this.displayString = beName + this.displayString;
			}
		};
		this.buttonMuted = new ConfigButtonBoolean(bmLayout.x(), bmLayout.y(), bmLayout.width(), bmLayout.height(), this.configBoolean2) {
			@Override
			public void updateDisplayString() {
				super.updateDisplayString();
				this.displayString = bmName + this.displayString;
			}
		};
		this.nameWidget = method_37063(new class_342(this.field_22793, nwLayout.width(), nwLayout.height(), class_2561.method_30163("")));
		this.nameWidget.method_1852(macro.getName());
		this.nameWidget.method_48229(nwLayout.x(), nwLayout.y());
	}

	@Override
	public boolean method_25404(int keyCode, int scanCode, int modifiers) {
		buttonEnabled.onKeyTyped(keyCode, scanCode, modifiers);
		buttonMuted.onKeyTyped(keyCode, scanCode, modifiers);
		widgetAdvancedKeybindSettings.onKeyTyped(keyCode, scanCode, modifiers);
		buttonKeybind.onKeyPressed(keyCode);
		if (buttonKeybind.isSelected() && keyCode == 256) {
			this.macro.hotkey.getKeybind().clearKeys();
			buttonKeybind.onClearSelection();
			return true;
		}
		if (this.commandList.method_25404(keyCode, scanCode, modifiers))
			return true;
		else
			return super.method_25404(keyCode, scanCode, modifiers);
	}

	@Override
	public void method_16014(double mouseX, double mouseY) {
		commandList.method_16014(mouseX, mouseY);
	}

	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		if (buttonKeybind.onMouseClicked((int) mouseX, (int) mouseY, button)) {
			if (this.method_25399() != null) {
				this.method_25399().method_25365(false);
			}
			return true;
		}
		else if (buttonEnabled.onMouseClicked((int) mouseX, (int) mouseY, button)) {
			if (this.method_25399() != null) {
				this.method_25399().method_25365(false);
			}
			return true;
		}
		else if (buttonMuted.onMouseClicked((int) mouseX, (int) mouseY, button)) {
			if (this.method_25399() != null) {
				this.method_25399().method_25365(false);
			}
			return true;
		}
		else if (widgetAdvancedKeybindSettings.onMouseClicked((int) mouseX, (int) mouseY, button)) {
			if (this.method_25399() != null) {
				this.method_25399().method_25365(false);
			}
			return true;
		}
		else if (super.method_25402(mouseX, mouseY, button)) return true;
		else return commandList.method_25402(mouseX, mouseY, button);
	}

	@Override
	public boolean method_25406(double mouseX, double mouseY, int button) {
		buttonKeybind.onMouseReleased((int) mouseX, (int) mouseY, button);
		buttonEnabled.onMouseReleased((int) mouseX, (int) mouseY, button);
		buttonMuted.onMouseReleased((int) mouseX, (int) mouseY, button);
		widgetAdvancedKeybindSettings.onMouseReleased((int) mouseX, (int) mouseY, button);
		if (commandList.method_25406(mouseX, mouseY, button)) return true;
		else return super.method_25406(mouseX, mouseY, button);
	}

	@Override
	public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
		if (commandList.method_25403(mouseX, mouseY, button, deltaX, deltaY)) return true;
		else return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
	}

	@Override
	public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
		if (commandList.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) return true;
		else if (buttonKeybind.onMouseScrolled((int) mouseX, (int) mouseY, horizontalAmount, verticalAmount))
			return true;
		else if (widgetAdvancedKeybindSettings.onMouseScrolled((int) mouseX, (int) mouseY, horizontalAmount, verticalAmount))
			return true;
		else if (buttonEnabled.onMouseScrolled((int) mouseX, (int) mouseY, horizontalAmount, verticalAmount))
			return true;
		else if (buttonMuted.onMouseScrolled((int) mouseX, (int) mouseY, horizontalAmount, verticalAmount))
			return true;
		else return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
	}

	@Override
	public boolean method_16803(int keyCode, int scanCode, int modifiers) {
		if (commandList.method_16803(keyCode, scanCode, modifiers)) return true;
		else return super.method_16803(keyCode, scanCode, modifiers);
	}

	@Override
	public boolean method_25400(char chr, int modifiers) {
		if (commandList.method_25400(chr, modifiers)) return true;
		else if (buttonKeybind.onCharTyped(chr, modifiers)) return true;
		else if (buttonEnabled.onCharTyped(chr, modifiers)) return true;
		else if (buttonMuted.onCharTyped(chr, modifiers)) return true;
		else if (widgetAdvancedKeybindSettings.onCharTyped(chr, modifiers)) return true;
		else return super.method_25400(chr, modifiers);
	}

	@Override
	public boolean method_25405(double mouseX, double mouseY) {
		if (commandList.method_25405(mouseX, mouseY)) return true;
		else if (buttonKeybind.isMouseOver((int) mouseX, (int) mouseY)) return true;
		else if (buttonEnabled.isMouseOver((int) mouseX, (int) mouseY)) return true;
		else if (buttonMuted.isMouseOver((int) mouseX, (int) mouseY)) return true;
		else if (widgetAdvancedKeybindSettings.isMouseOver((int) mouseX, (int) mouseY)) return true;
		else return super.method_25405(mouseX, mouseY);
	}

	@Override
	public void method_25419() {
		if (MacroManager.nameExists(this.nameWidget.method_1882(), this.macro)) {
			errorCountDown = 50.0f;
			return;
		}
		this.macro.actions.clear();
		this.commandList.method_25396().forEach(t -> this.macro.actions.add(t.command));
		this.macro.setEnabled(this.configBoolean.getBooleanValue());
		this.macro.muted = this.configBoolean2.getBooleanValue();
		this.macro.setName(this.nameWidget.method_1882());
		MacroManager.saveChanges();
		assert field_22787 != null;
		parent.initGui();
		GuiBase.openGui(parent);
	}
}
