package tools.redstone.redstonetools.mixin.features;

import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_636;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tools.redstone.redstonetools.features.toggleable.AirPlaceFeature;

@Mixin(class_310.class)
public class AirPlaceClientMixin {
	@Shadow
	public class_239 crosshairTarget;

	@Inject(method = "doItemUse", at = @At(value = "HEAD"))
	public void doItemUse(CallbackInfo callbackInfo) {
		if (!isAirPlaceAllowed()) {
			return;
		}

		crosshairTarget = AirPlaceFeature.findAirPlaceBlockHit(getPlayer());
	}

	@Inject(method = "doAttack", at = @At(value = "HEAD"))
	public void doAttack(CallbackInfoReturnable<Boolean> cir) {
		if (!isAirPlaceAllowed()) {
			return;
		}

		// Call interactionManager directly because the block is air, with which the player cannot interact
		var hit = AirPlaceFeature.findAirPlaceBlockHit(getPlayer());
		getInteractionManager().method_2910(hit.method_17777(), hit.method_17780());
	}

	@Unique
	private boolean isAirPlaceAllowed() {
		// If air place is disabled
		if (!AirPlaceFeature.INSTANCE.isEnabled()) {
			return false;
		}

		// If the hit result is already set
		if (crosshairTarget != null && crosshairTarget.method_17783() != class_239.class_240.field_1333) {
			return false;
		}

		// If the player or interactionManager not initialized
		if (getPlayer() == null || getInteractionManager() == null) {
			return false;
		}

		// If air place isn't possible with the current
		// player equipment and state
		return AirPlaceFeature.canAirPlace(getPlayer());
	}

	@Unique
	private class_310 getMinecraftClient() {
		return (class_310) (Object) this;
	}

	@Unique
	private class_746 getPlayer() {
		return getMinecraftClient().field_1724;
	}

	@Unique
	private class_636 getInteractionManager() {
		return getMinecraftClient().field_1761;
	}

}
