package tools.redstone.redstonetools.mixin.features;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import tools.redstone.redstonetools.features.toggleable.AutoRotateFeature;
import tools.redstone.redstonetools.utils.BlockUtils;

@Mixin(class_1747.class)
public abstract class AutoRotateMixin {
	@Shadow
	protected abstract boolean canPlace(class_1750 context, class_2680 state);

	@ModifyReturnValue(method = "getPlacementState", at = @At("RETURN"))
	private class_2680 changeRotation(class_2680 original, @Local(argsOnly = true) class_1750 context) {
		if (!(context.method_8036() instanceof class_3222 player))         return original;
		if (player.method_5682() == null)                                          return original;
		if (!player.method_5682().method_3816())                                   return original;
		if (!AutoRotateFeature.INSTANCE.isEnabled(player)) return original;
		if (original == null)                                                    return null;

		class_2680 backup = original;
		original = BlockUtils.rotate(original);

		if (this.canPlace(context, original))
			return original;
		else if (this.canPlace(context, backup))
			return backup;
		else
			return null;
	}
}