package tools.redstone.redstonetools.mixin.features;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tools.redstone.redstonetools.utils.StringUtils;

import static tools.redstone.redstonetools.utils.StringUtils.unmodifiedCommand;

import net.minecraft.class_342;
import net.minecraft.class_4717;

@Mixin(class_4717.class)
public class ChatInputSuggesterMixin {
	@Final
	@Shadow
	class_342 textField;

	@Unique
	private boolean justEntered;
	@Unique
	private int cursor;
	@Unique
	private int lastCursor;

	@Inject(method = "refresh", at = @At("HEAD"), cancellable = true)
	private void meowww(CallbackInfo ci) {
		if (justEntered) {
			ci.cancel();
			return;
		}
		justEntered = true;
		cursor = textField.method_1881();
		unmodifiedCommand.add(textField.method_1882());
		textField.method_1852(StringUtils.insertVariablesAndMath(textField.method_1882()));
	}

	@Inject(method = "refresh", at = @At("RETURN"))
	private void mrawww(CallbackInfo ci) {
		textField.method_1852(unmodifiedCommand.getLast());
		if (lastCursor != cursor) {
			textField.method_1883(cursor, false);
		}
		unmodifiedCommand.removeLast();
		justEntered = false;
		lastCursor = textField.method_1881();
	}
}
