package tools.redstone.redstonetools.mixin.features;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tools.redstone.redstonetools.malilib.config.Configs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2172;

import static net.minecraft.class_2172.field_55224;

@Mixin(class_2172.class)
public interface CommandSourceMixin {
	@Inject(method = "shouldSuggest", at = @At("HEAD"), cancellable = true)
	private static void meow(String remaining, String candidate, CallbackInfoReturnable<Boolean> cir) {
		if (!Configs.General.BOOLEAN_IMPROVED_COMMAND_SUGGESTIONS.getBooleanValue()) return;
		if (candidate == null) {
			cir.setReturnValue(false);
			return;
		}
		if (remaining.isEmpty()) {
			cir.setReturnValue(true);
			return;
		}

		int n = candidate.length();
		List<Integer> starts = new ArrayList<>();
		starts.add(0);
		for (int i = 0; i < n; i++) {
			if (field_55224.matches(candidate.charAt(i))) {
				starts.add(i + 1);
			}
		}

		for (int start : starts) {
			if (isSubsequenceFrom(remaining, candidate, start)) {
				cir.setReturnValue(true);
				return;
			}
		}
		cir.setReturnValue(false);
	}

	@Unique
	private static boolean isSubsequenceFrom(String remaining, String candidate, int startIdx) {
		int j = 0;
		for (int i = startIdx; i < candidate.length() && j < remaining.length(); i++) {
			if (candidate.charAt(i) == remaining.charAt(j)) {
				j++;
			}
		}
		return j == remaining.length();
	}
}
