package tools.redstone.redstonetools.utils;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.fabric.FabricAdapter;
import com.sk89q.worldedit.regions.Region;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class WorldEditUtils {
	public static Region getSelection(class_3222 player) throws CommandSyntaxException {
		if (!DependencyLookup.WORLDEDIT_PRESENT) {
			throw new IllegalStateException("WorldEdit is not loaded.");
		}

		var actor = FabricAdapter.adaptPlayer(player);

		var localSession = WorldEdit.getInstance()
				.getSessionManager()
				.get(actor);

		var selectionWorld = localSession.getSelectionWorld();

		try {
			return localSession.getSelection(selectionWorld);
		} catch (IncompleteRegionException ex) {
			throw new SimpleCommandExceptionType(class_2561.method_43470("Please make a selection with WorldEdit first")).create();
		}
	}
}
