package tools.redstone.redstonetools.features.commands;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.class_2168;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import tools.redstone.redstonetools.utils.BlockInfo;

public abstract class BlockRaycastFeature {
	protected int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
		class_3222 player = context.getSource().method_44023();
		class_3218 world = context.getSource().method_9225();
		if (player == null || context.getSource().method_9225() == null) {
			throw new CommandSyntaxException(null, class_2561.method_30163("This command is client-side only."));
		}
		double maxDistance = player.method_45325(class_5134.field_47758);
		class_3965 hitresult = (class_3965) player.method_5745(maxDistance, 1.0f, false);

		if (hitresult.method_17783() == class_239.class_240.field_1333) {
			if (requiresBlock()) {
				throw new SimpleCommandExceptionType(class_2561.method_43470("You must be looking at a block to use this command.")).create();
			} else {
				return execute(context, null);
			}
		}

		var blockPos = (hitresult).method_17777();
		var blockState = world.method_8320(blockPos);
		var blockEntity = world.method_8321(blockPos);
		var block = blockState.method_26204();

		return execute(context, new BlockInfo(block, blockPos, blockState, blockEntity));
	}

	protected boolean requiresBlock() {
		return true;
	}

	protected abstract int execute(CommandContext<class_2168> context, BlockInfo blockInfo) throws CommandSyntaxException;
}
