package tools.redstone.redstonetools.features.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import java.util.HashMap;
import java.util.Map;

import static net.fabricmc.fabric.api.client.command.v2.ClientCommandManager.argument;
import static net.fabricmc.fabric.api.client.command.v2.ClientCommandManager.literal;

public class ClientDataFeature {
	public Map<String, String> variables = new HashMap<>();
	public static final ClientDataFeature INSTANCE = new ClientDataFeature();

	public void registerCommand(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
		dispatcher.register(literal("clientdata")
			.then(literal("set")
				.then(argument("name", StringArgumentType.word())
					.then(argument("value", StringArgumentType.greedyString())
						.executes(context -> {
								String name = StringArgumentType.getString(context, "name");
								String value = StringArgumentType.getString(context, "value");
								variables.put(name, value);
								context.getSource().sendFeedback(class_2561.method_30163("Set " + name + " to \"" + value + "\""));
								return 1;
							}
						)
					)
				)
			)
			.then(literal("delete")
				.then(argument("name", StringArgumentType.word())
					.executes(context -> {
							variables.remove(StringArgumentType.getString(context, "name"));
							return 1;
						}
					)
				)
			)
		);
	}
}
