package tools.redstone.redstonetools.features.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import tools.redstone.redstonetools.utils.ArgumentUtils;
import tools.redstone.redstonetools.utils.BlockColor;
import tools.redstone.redstonetools.utils.BlockInfo;
import tools.redstone.redstonetools.utils.ColoredBlockType;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_7157;

public class ColoredFeature extends PickBlockFeature {
	public static final ColoredFeature INSTANCE = new ColoredFeature();

	protected ColoredFeature() {
	}

	public void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 registrationEnvironment) {
			dispatcher.register(class_2170.method_9247("colored")
				.requires(source -> source.method_9259(2))
				.executes(this::execute)
				.then(class_2170.method_9244("blockType", StringArgumentType.string()).suggests(ArgumentUtils.COLORED_BLOCK_TYPE_SUGGESTION_PROVIDER)
					.executes(this::execute)));
	}

	public static ColoredBlockType blockType;

	protected boolean requiresBlock() {
		return false;
	}

	protected class_1799 getItemStack(CommandContext<class_2168> context, @Nullable BlockInfo blockInfo) {
		var color = blockInfo == null
				? BlockColor.WHITE
				: BlockColor.fromBlock(blockInfo.block);

		var coloredBlock = blockType.withColor(color);

		return new class_1799(coloredBlock.toBlock());
	}

	@Override
	protected int execute(CommandContext<class_2168> context, @Nullable BlockInfo blockInfo) throws CommandSyntaxException {
		try {
			blockType = ArgumentUtils.parseColoredBlockType(context, "blockType");
		} catch (Exception e) {
			blockType = ColoredBlockType.WOOL;
		}
		return super.execute(context, blockInfo);
	}
}
