package tools.redstone.redstonetools.features.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import tools.redstone.redstonetools.mixin.AbstractBlockMixin;
import tools.redstone.redstonetools.mixin.features.ServerPlayNetworkHandlerAccessor;
import tools.redstone.redstonetools.utils.BlockInfo;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_7157;
import net.minecraft.class_9275;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class CopyStateFeature extends PickBlockFeature {
	public static final CopyStateFeature INSTANCE = new CopyStateFeature();

	protected CopyStateFeature() {
	}

	public void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 registrationEnvironment) {
			dispatcher.register(class_2170.method_9247("copystate").requires(source -> source.method_9259(2)).executes(this::execute));
	}

	@Override
	protected class_1799 getItemStack(CommandContext<class_2168> context, BlockInfo blockInfo) {
		Objects.requireNonNull(blockInfo);
		class_1799 stack = ((AbstractBlockMixin) blockInfo.state.method_26204()).callGetPickStack(context.getSource().method_9225(), blockInfo.pos, blockInfo.state, true);

		ServerPlayNetworkHandlerAccessor.callCopyBlockDataToStack(blockInfo.state, context.getSource().method_9225(), blockInfo.pos, stack);

		List<class_2561> lore = new ArrayList<>();
		if (blockInfo.entity != null) {
			lore.add(class_2561.method_43470("Has block entity data"));
		}

		if (!blockInfo.state.method_28501().isEmpty()) {
			class_9275 component = class_9275.field_49284;
			for (class_2769<?> property : blockInfo.state.method_28501()) {
				component = addToLoreAndComponent(lore, component, blockInfo.state, property);
			}

			stack.method_57379(class_9334.field_49623, component);
		}
		stack.method_57379(class_9334.field_49632, new class_9290(lore));

		return stack;
	}

	private static <T extends Comparable<T>> class_9275 addToLoreAndComponent(List<class_2561> lore, class_9275 component, class_2680 state, class_2769<T> property) {
		lore.add(class_2561.method_30163("   " + property.method_11899() + ": " + state.method_11654(property)));
		return component.method_57420(property, state.method_11654(property));
	}
}
