/*
	This file is licenced under the MPL 2.0
	https://www.mozilla.org/en-US/MPL/2.0/

	Command from: https://github.com/SpiritGameStudios/Specter/blob/65c217ad4776dbbfacbe8bac8a3d4e9ccd9bdd30/specter-debug/src/main/java/dev/spiritstudios/specter/impl/debug/command/ComponentsCommand.java
 */

package tools.redstone.redstonetools.features.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_6903;
import net.minecraft.class_7157;
import net.minecraft.class_9326;

public class ItemComponentsFeature {
	public static final ItemComponentsFeature INSTANCE = new ItemComponentsFeature();

	protected ItemComponentsFeature() {
	}

	private final SimpleCommandExceptionType NO_COMPONENTS_EXCEPTION = new SimpleCommandExceptionType(class_2561.method_43470("No components!"));

	public void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 registrationEnvironment) {
		dispatcher.register(
			class_2170.method_9247("components")
				.requires(source -> source.method_9259(2))
				.executes(context -> components(Objects.requireNonNull(context.getSource().method_44023()).method_6047(), context.getSource()))
				.then(class_2170.method_9244("target", class_2186.method_9305())
					.executes(context -> components(class_2186.method_9315(context, "target").method_6047(), context.getSource()))
				)
		);
	}

	private int components(class_1799 stack, class_2168 source) throws CommandSyntaxException {
		class_9326 components = stack.method_57380();
		if (components.method_57848())
			throw NO_COMPONENTS_EXCEPTION.create();

		class_6903<class_2520> ops = source.method_30497().method_57093(class_2509.field_11560);
		class_2520 output = class_9326.field_49589.encodeStart(ops, components).getOrThrow();

		source.method_9226(() -> class_2512.method_32270(output), false);

		return Command.SINGLE_SUCCESS;
	}
}
