package tools.redstone.redstonetools.features.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import tools.redstone.redstonetools.utils.PositionUtils;
import tools.redstone.redstonetools.utils.RaycastUtils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3965;
import net.minecraft.class_7157;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class QuickTpFeature {
	public static final QuickTpFeature INSTANCE = new QuickTpFeature();

	protected QuickTpFeature() {
	}

	public void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 registrationEnvironment) {
			dispatcher.register(method_9247("quicktp")
				.requires(source -> source.method_9259(2))
				.executes(this::parseArguments)
				.then(method_9244("distance", DoubleArgumentType.doubleArg())
						.executes(this::parseArguments)
						.then(method_9244("throughFluids", BoolArgumentType.bool())
								.executes(this::parseArguments)
								.then(method_9244("resetVelocity", BoolArgumentType.bool())
										.executes(this::parseArguments)))));
	}

	protected int parseArguments(CommandContext<class_2168> context) throws CommandSyntaxException {
		var player = context.getSource().method_44023();

		if (quicktpingForPlayer.contains(player)) throw new SimpleCommandExceptionType(class_2561.method_43470("Already doing a quicktp!")).create();
		quicktpingForPlayer.add(player);
		double distance;
		boolean includeFluids;
		boolean resetVelocity;
		try {
			distance = DoubleArgumentType.getDouble(context, "distance");
		} catch (Exception ignored) {
			distance = 50.0;
		}
		try {
			includeFluids = BoolArgumentType.getBool(context, "throughFluids");
		} catch (Exception ignored) {
			includeFluids = false;
		}
		try {
			resetVelocity = BoolArgumentType.getBool(context, "resetVelocity");
		} catch (Exception ignored) {
			resetVelocity = true;
		}
		double finalDistance = distance;
		boolean finalIncludeFluids = !includeFluids;
		boolean finalResetVelocity = resetVelocity;
		Thread thread = new Thread(() -> {
			try {
				execute(context, finalDistance, finalIncludeFluids, finalResetVelocity);
			} catch (CommandSyntaxException e) {
				throw new RuntimeException(e);
			}
		});
		thread.start();
		Thread t2 = new Thread(() -> {
			try {
				thread.join(10000);
			} catch (InterruptedException ignored) {
			}
			if (thread.isAlive()) {
				player.method_64398(class_2561.method_43470("Quicktp still running after 10 seconds. Canceling quicktp!"));
				quicktpingForPlayer.remove(player);
			}
			thread.interrupt();
		});
		t2.start();
		return 1;
	}

	public static List<class_1657> quicktpingForPlayer = new ArrayList<>();

	protected static void execute(CommandContext<class_2168> context, double distance, boolean includeFluids, boolean resetVelocity) throws CommandSyntaxException {
		var player = context.getSource().method_44023();
		assert player != null;
		try {
			var hit = player.method_5745(distance, 0, includeFluids);

			var targetPosition = clampHitPosition(hit);

			player.method_5859(targetPosition.field_1352, targetPosition.field_1351, targetPosition.field_1350);
			if (resetVelocity) player.method_18799(class_243.field_1353);
			player.field_6017 = 0;
			player.field_6037 = true; // guh
		} finally {
			quicktpingForPlayer.remove(player);
		}
	}

	private static class_243 clampHitPosition(class_239 hit) {
		if (hit.method_17783() != class_239.class_240.field_1332) {
			return hit.method_17784().method_1023(0, 0.5, 0);
		}

		var blockHit = (class_3965) hit;

		var neighbor = RaycastUtils.getBlockHitNeighbor(blockHit);
		var neighborPos = neighbor.method_17777();

		return PositionUtils.getBottomPositionOfBlock(neighborPos);
	}
}
