package tools.redstone.redstonetools.malilib.widget.action;

import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import tools.redstone.redstonetools.macros.actions.CommandAction;
import tools.redstone.redstonetools.malilib.GuiMacroEditor;
import tools.redstone.redstonetools.malilib.widget.macro.MacroBase;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_4717;
import net.minecraft.class_6382;

public class CommandListWidget extends class_350<CommandListWidget.CommandEntry> {
	private final GuiMacroEditor parent;
	private final MacroBase macro;

	public CommandListWidget(GuiMacroEditor parent, class_310 mc, int width, int height, int y, int itemHeight, MacroBase macro) {
		super(mc, width, height, y, itemHeight);
		this.parent = parent;
		this.macro = macro;
		this.macro.actions.forEach((t) -> this.method_25396().add(new CommandEntry(t, this)));
	}

	@Override
	protected void method_25339() {
		this.method_25396().clear();
		super.method_25339();
	}

	@Override
	public int method_25322() {
		return this.field_22758 - 50;
	}

	public void addEntry() {
		this.macro.actions.addFirst(new CommandAction(""));
		this.method_44399(new CommandEntry(this.macro.actions.getFirst(), this));
		this.method_25324(this.method_48200());
	}

	CommandEntry previousSelected = this.method_25334();

	@Override
	public void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
		if (this.method_25367()) {
			if (this.method_25334() != null) {
				this.method_25334().setFocused(true);
				if (previousSelected != null)
					this.previousSelected.setFocused(false);
			}
		} else {
			if (this.method_25334() != null)
				this.method_25334().setFocused(false);
			if (this.previousSelected != null)
				this.previousSelected.setFocused(false);
			this.method_25313(null);
		}
		this.previousSelected = this.method_25334();
		super.method_48579(context, mouseX, mouseY, deltaTicks);
	}

	@Override
	protected void method_47399(class_6382 builder) {

	}

	@Override
	public void method_16014(double mouseX, double mouseY) {
		if (this.method_25334() != null) {
			this.method_25334().mouseMoved(mouseX, mouseY);
		}
		super.method_16014(mouseX, mouseY);
	}

	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		if (this.method_25334() != null) {
			this.method_25334().mouseClicked(mouseX, mouseY, button);
		}
		return super.method_25402(mouseX, mouseY, button);
	}

	@Override
	public boolean method_25406(double mouseX, double mouseY, int button) {
		if (this.method_25334() != null) {
			return this.method_25334().mouseReleased(mouseX, mouseY ,button);
		}
		return super.method_25406(mouseX, mouseY, button);
	}

	@Override
	public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
		if (this.method_25334() != null) {
			return this.method_25334().mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
		}
		return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
	}

	@Override
	public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
		if (this.method_25334() != null) {
			return this.method_25334().mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
		}
		return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
	}

	@Override
	public boolean method_25404(int keyCode, int scanCode, int modifiers) {
		if (this.method_25334() != null) {
			return this.method_25334().keyPressed(keyCode, scanCode, modifiers);
		}
		return super.method_25404(keyCode, scanCode, modifiers);
	}

	@Override
	public boolean method_16803(int keyCode, int scanCode, int modifiers) {
		if (this.method_25334() != null) {
			return this.method_25334().keyReleased(keyCode, scanCode, modifiers);
		}
		return super.method_16803(keyCode, scanCode, modifiers);
	}

	@Override
	public boolean method_25400(char chr, int modifiers) {
		if (this.method_25334() != null) {
			return this.method_25334().charTyped(chr, modifiers);
		}
		return super.method_25400(chr, modifiers);
	}

	@Override
	public boolean method_25405(double mouseX, double mouseY) {
		if (this.method_25334() != null) {
			return this.method_25334().isMouseOver(mouseX, mouseY);
		}
		return super.method_25405(mouseX, mouseY);
	}

	public static class CommandEntry extends class_350.class_351<CommandListWidget.CommandEntry> {
		public final CommandAction command;
		public final class_342 commandWidget;
		private final CommandListWidget parent;
		private boolean isFirst = true;
		private ButtonBase removeButton = new ButtonGeneric(0, 0, 0, 0, "Remove");

		public CommandEntry(CommandAction command, CommandListWidget parent) {
			this.parent = parent;
			this.command = command;
			this.commandWidget = new class_342(class_310.method_1551().field_1772, 250, 50, class_2561.method_30163(""));
			this.commandWidget.method_1880(256);
			this.commandWidget.method_1852(command.command);
			var commandSuggester = new class_4717(class_310.method_1551(), this.parent.parent, this.commandWidget, class_310.method_1551().field_1772, false, false, 0, 7, false, Integer.MIN_VALUE) {
				@Override
				public void method_23934() {
					if (parent.field_22740 == null) return;
					if (parent.field_22740.method_1562() == null) return;
					super.method_23934();
				}
			};
			commandSuggester.method_23933(true);
			commandSuggester.method_23934();
		}

		private static Method m;

		@Override
		public void render(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
			if (isFirst) {
				isFirst = false;
				this.removeButton = new ButtonGeneric(x + entryWidth, y, -1, 20, "Remove");
				this.removeButton.setActionListener((t, g) -> {
					this.parent.macro.actions.remove(this.parent.method_25396().indexOf(this));
					this.parent.method_25330(this);
				});
				this.removeButton.setX(removeButton.getX() - (removeButton.getWidth() + 10));
			}
			removeButton.setY(y + 6);

			if (this.isFocused()) {
				this.parent.parent.macro.setName(this.parent.parent.nameWidget.method_1882());
				class_310.method_1551().method_1507(new CommandEditScreen(parent.parent, this.commandWidget));
				this.parent.method_25313(null);
			}

			commandWidget.method_25365(this.isFocused());
			commandWidget.method_48229(x + 4, y + 3);
			commandWidget.method_25358(entryWidth - 100);
			commandWidget.method_53533(26);
			commandWidget.method_25394(context, mouseX, mouseY, tickProgress);
			try {
				removeButton.render(context, mouseX, mouseY, removeButton.isMouseOver());
			} catch (NoSuchMethodError ignored) {
				if (m == null) {
					try {
						m = ButtonBase.class.getMethod("render", int.class, int.class, boolean.class, class_332.class);
					} catch (Exception e) {
						throw new RuntimeException("Something went wrong. Contact a redstonetools developer", e);
					}
				}
				try {
					m.invoke(removeButton, mouseX, mouseY, removeButton.isMouseOver(), context);
				} catch (IllegalAccessException | InvocationTargetException e) {
					throw new RuntimeException("Something went wrong. Contact a redstonetools developer", e);
				}
			}
			command.command = commandWidget.method_1882();
		}

		@Override
		public void mouseMoved(double mouseX, double mouseY) {
			commandWidget.method_16014(mouseX, mouseY);
			super.mouseMoved(mouseX, mouseY);
		}

		@Override
		public boolean mouseClicked(double mouseX, double mouseY, int button) {
			if (commandWidget.method_25402(mouseX, mouseY, button)) return true;
			else return removeButton.onMouseClicked((int)mouseX, (int)mouseY, button);
		}

		@Override
		public boolean mouseReleased(double mouseX, double mouseY, int button) {
			return commandWidget.method_25406(mouseX, mouseY ,button);
		}

		@Override
		public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
			return commandWidget.method_25403(mouseX, mouseY, button, deltaX, deltaY);
		}

		@Override
		public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
			return commandWidget.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
		}

		@Override
		public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
			return commandWidget.method_25404(keyCode, scanCode, modifiers);
		}

		@Override
		public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
			return commandWidget.method_16803(keyCode, scanCode, modifiers);
		}

		@Override
		public boolean charTyped(char chr, int modifiers) {
			return commandWidget.method_25400(chr, modifiers);
		}

		@Override
		public boolean isMouseOver(double mouseX, double mouseY) {
			return commandWidget.method_25405(mouseX, mouseY);
		}
	}
}
