package tools.redstone.redstonetools.mixin.features;

import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.fabric.impl.command.client.ClientCommandInternals;
import net.minecraft.class_2172;
import net.minecraft.class_2641;
import net.minecraft.class_5455;
import net.minecraft.class_634;
import net.minecraft.class_637;
import net.minecraft.class_7157;
import net.minecraft.class_7699;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tools.redstone.redstonetools.ClientCommands;
import tools.redstone.redstonetools.utils.DependencyLookup;
import tools.redstone.redstonetools.utils.StringUtils;

@Mixin(class_634.class)
public class ClientPlayNetworkHandlerMixin {
	@Inject(method = "onCommandTree", at = @At("RETURN"), order = 750)
	private void onOnCommandTree(class_2641 packet, CallbackInfo info) {
		var parse = commandDispatcher.parse("base 0x2 5", commandSource); // there's probably a better way to check for rst being on the server, but I cba rn
		DependencyLookup.REDSTONE_TOOLS_SERVER_PRESENT = !parse.getReader().canRead();
		ClientCommands.registerCommands(ClientCommandInternals.getActiveDispatcher(), class_7157.method_46722(this.combinedDynamicRegistries, this.enabledFeatures));
	}
	@Shadow
	private CommandDispatcher<class_2172> commandDispatcher;

	@Shadow
	@Final
	private class_637 commandSource;

	@Final
	@Shadow
	private class_7699 enabledFeatures;

	@Final
	@Shadow
	private class_5455.class_6890 combinedDynamicRegistries;

	@ModifyVariable(method = "sendChatCommand", at = @At("HEAD"), argsOnly = true, order = 750)
	public String sendChatCommand(String command) {
		return StringUtils.insertVariablesAndMath(command);
	}
}
