package tools.redstone.redstonetools.mixin.features;

import com.mojang.brigadier.ParseResults;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tools.redstone.redstonetools.features.commands.ItemBindFeature;

@Mixin(class_2170.class)
public class CommandManagerMixin {
	@Inject(method = "execute", at = @At("HEAD"), cancellable = true)
	public void checkItemBind(ParseResults<class_2168> parseResults, String command, CallbackInfo ci) {
		class_3222 player = parseResults.getContext().getSource().method_44023();
		if (ItemBindFeature.waitingForCommandForPlayer(player)) {
			ItemBindFeature.addCommand(command, player);
			ItemBindFeature.playersWaitingForCommand.remove(player);
			ci.cancel();
		}
	}
}
