package tools.redstone.redstonetools.utils;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class ArgumentUtils {
	public static final String[] BLOCK_COLOR_SUGGESTIONS = EnumUtils.lowercaseNames(BlockColor.values());

	public static final String[] SIGNAL_BLOCK_SUGGESTIONS = EnumUtils.lowercaseNames(SignalBlock.values());

	public static final String[] DIRECTION_SUGGESTIONS = EnumUtils.lowercaseNames(DirectionArgument.values());

	public static final String[] COLORED_BLOCK_TYPE_SUGGESTIONS = EnumUtils.lowercaseNames(ColoredBlockType.values());

	public static final SuggestionProvider<class_2168> BLOCK_COLOR_SUGGESTION_PROVIDER = (context, builder) -> {
		Stream<String> names = Arrays.stream(BLOCK_COLOR_SUGGESTIONS);

		class_2172.method_9264(names, builder);
		return builder.buildFuture();
	};

	public static final SuggestionProvider<class_2168> SIGNAL_BLOCK_SUGGESTION_PROVIDER = (context, builder) -> {
		Stream<String> names = Arrays.stream(SIGNAL_BLOCK_SUGGESTIONS);

		class_2172.method_9264(names, builder);
		return builder.buildFuture();
	};

	public static final SuggestionProvider<class_2168> DIRECTION_SUGGESTION_PROVIDER = (context, builder) -> {
		Stream<String> names = Arrays.stream(DIRECTION_SUGGESTIONS);

		class_2172.method_9264(names, builder);
		return builder.buildFuture();
	};

	public static final SuggestionProvider<class_2168> COLORED_BLOCK_TYPE_SUGGESTION_PROVIDER = (context, builder) -> {
		Stream<String> names = Arrays.stream(COLORED_BLOCK_TYPE_SUGGESTIONS);

		class_2172.method_9264(names, builder);
		return builder.buildFuture();
	};

	public static SignalBlock parseSignalBlock(CommandContext<class_2168> context, final String name) throws CommandSyntaxException {
		String result = context.getArgument(name, String.class);
		SignalBlock signalBlock = EnumUtils.byNameOrNull(SignalBlock.values(), result);
		if (signalBlock == null) {
			throw new SimpleCommandExceptionType(class_2561.method_43470("Could not resolve signal block!")).create();
		}
		return signalBlock;
	}

	public static BlockColor parseBlockColor(CommandContext<class_2168> context, final String name) throws CommandSyntaxException {
		String result = context.getArgument(name, String.class);
		BlockColor color = EnumUtils.byNameOrNull(BlockColor.values(), result);
		if (color == null) {
			throw new SimpleCommandExceptionType(class_2561.method_43470("Could not resolve block color!")).create();
		}
		return color;
	}

	public static ColoredBlockType parseColoredBlockType(CommandContext<class_2168> context, final String name) throws CommandSyntaxException {
		String result = context.getArgument(name, String.class);
		ColoredBlockType blockType = EnumUtils.byNameOrNull(ColoredBlockType.values(), result);
		if (blockType == null) {
			throw new SimpleCommandExceptionType(class_2561.method_43470("Could not resolve colored block type!")).create();
		}
		return blockType;
	}

	public static DirectionArgument parseDirection(CommandContext<class_2168> context, final String name) throws CommandSyntaxException {
		String result = context.getArgument(name, String.class);
		DirectionArgument direction = EnumUtils.byNameOrNull(DirectionArgument.values(), result);
		if (direction == null) {
			throw new SimpleCommandExceptionType(class_2561.method_43470("Could not resolve direction!")).create();
		}
		return direction;
	}
}
