package tools.redstone.redstonetools.utils;

import java.util.Locale;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;

public enum SignalBlock {
	// cba to do composters.
	BARREL(class_2246.field_16328, SignalBlockSupplier.container(27, class_2246.field_16328.method_8389())),
	CHEST(class_2246.field_10034, SignalBlockSupplier.container(27, class_2246.field_10034.method_8389())),
	SHULKER_BOX(class_2246.field_10603, SignalBlockSupplier.container(27, class_2246.field_10603.method_8389())),
	DISPENSER(class_2246.field_10200, SignalBlockSupplier.container(9, class_2246.field_10200.method_8389())),
	DROPPER(class_2246.field_10228, SignalBlockSupplier.container(9, class_2246.field_10228.method_8389())),
	HOPPER(class_2246.field_10312, SignalBlockSupplier.container(5, class_2246.field_10312.method_8389())),
	BREWING_STAND(class_2246.field_10333, SignalBlockSupplier.container(5, class_2246.field_10333.method_8389())),
	FURNACE(class_2246.field_10181, SignalBlockSupplier.container(3, class_2246.field_10181.method_8389())),
	SMOKER(class_2246.field_16334, SignalBlockSupplier.container(3, class_2246.field_16334.method_8389())),
	BLAST_FURNACE(class_2246.field_16333, SignalBlockSupplier.container(3, class_2246.field_16333.method_8389())),
	COMMAND_BLOCK(class_2246.field_10525, SignalBlockSupplier.commandBlock()),
	AUTO(null, null);

	private final class_2248 block;
	private final SignalBlockSupplier supplier;

	SignalBlock(class_2248 block, SignalBlockSupplier supplier) {
		this.block = block;
		this.supplier = supplier;
	}

	public static SignalBlock getBestBlock(int signal) {
		return signal < 1780
				? BARREL
				: COMMAND_BLOCK;
	}

	public class_1799 getItemStack(int signal) {
		if (block == null || supplier == null)
			return getBestBlock(signal).getItemStack(signal);

		return supplier.getItemStack(block, signal);
	}

	@Override
	public String toString() {
		return this.name().toLowerCase(Locale.ROOT);
	}

}
