/*
 * Decompiled with CFR 0.152.
 */
package tools.redstone.redstonetools.features.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_7157;
import tools.redstone.redstonetools.utils.PositionUtils;
import tools.redstone.redstonetools.utils.RaycastUtils;

public class QuickTpFeature {
    public static final QuickTpFeature INSTANCE = new QuickTpFeature();
    public static List<class_1657> quicktpingForPlayer = new ArrayList<class_1657>();

    protected QuickTpFeature() {
    }

    public void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"quicktp").requires(source -> source.method_9259(2))).executes(this::parseArguments)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"distance", (ArgumentType)DoubleArgumentType.doubleArg()).executes(this::parseArguments)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"throughFluids", (ArgumentType)BoolArgumentType.bool()).executes(this::parseArguments)).then(class_2170.method_9244((String)"resetVelocity", (ArgumentType)BoolArgumentType.bool()).executes(this::parseArguments)))));
    }

    protected int parseArguments(CommandContext<class_2168> context) throws CommandSyntaxException {
        boolean resetVelocity;
        boolean includeFluids;
        double distance;
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (quicktpingForPlayer.contains(player)) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Already doing a quicktp!")).create();
        }
        quicktpingForPlayer.add((class_1657)player);
        try {
            distance = DoubleArgumentType.getDouble(context, (String)"distance");
        }
        catch (Exception ignored) {
            distance = 50.0;
        }
        try {
            includeFluids = BoolArgumentType.getBool(context, (String)"throughFluids");
        }
        catch (Exception ignored) {
            includeFluids = false;
        }
        try {
            resetVelocity = BoolArgumentType.getBool(context, (String)"resetVelocity");
        }
        catch (Exception ignored) {
            resetVelocity = true;
        }
        double finalDistance = distance;
        boolean finalIncludeFluids = !includeFluids;
        boolean finalResetVelocity = resetVelocity;
        Thread thread = new Thread(() -> {
            try {
                QuickTpFeature.execute(context, finalDistance, finalIncludeFluids, finalResetVelocity);
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        });
        thread.start();
        Thread t2 = new Thread(() -> {
            try {
                thread.join(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (thread.isAlive()) {
                player.method_64398((class_2561)class_2561.method_43470((String)"Quicktp still running after 10 seconds. Canceling quicktp!"));
                quicktpingForPlayer.remove(player);
            }
            thread.interrupt();
        });
        t2.start();
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void execute(CommandContext<class_2168> context, double distance, boolean includeFluids, boolean resetVelocity) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        assert (player != null);
        try {
            class_239 hit = player.method_5745(distance, 0.0f, includeFluids);
            class_243 targetPosition = QuickTpFeature.clampHitPosition(hit);
            player.method_5859(targetPosition.field_1352, targetPosition.field_1351, targetPosition.field_1350);
            if (resetVelocity) {
                player.method_18799(class_243.field_1353);
            }
            player.field_6017 = 0.0;
            player.field_6037 = true;
        }
        finally {
            quicktpingForPlayer.remove(player);
        }
    }

    private static class_243 clampHitPosition(class_239 hit) {
        if (hit.method_17783() != class_239.class_240.field_1332) {
            return hit.method_17784().method_1023(0.0, 0.5, 0.0);
        }
        class_3965 blockHit = (class_3965)hit;
        class_3965 neighbor = RaycastUtils.getBlockHitNeighbor(blockHit);
        class_2338 neighborPos = neighbor.method_17777();
        return PositionUtils.getBottomPositionOfBlock(neighborPos);
    }
}

