/*
 * Decompiled with CFR 0.152.
 */
package tools.redstone.redstonetools.features.commands.argument;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import tools.redstone.redstonetools.malilib.config.MacroManager;
import tools.redstone.redstonetools.malilib.widget.macro.MacroBase;

@Environment(value=EnvType.CLIENT)
public class MacroArgumentType
implements ArgumentType<MacroBase> {
    private static final Collection<String> EXAMPLES = List.of(" ");

    public static MacroArgumentType macro() {
        return new MacroArgumentType();
    }

    public static MacroBase getMacro(CommandContext<?> context, String name) throws CommandSyntaxException {
        return (MacroBase)context.getArgument(name, MacroBase.class);
    }

    public MacroBase parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        String result = reader.getRemaining();
        reader.setCursor(reader.getTotalLength());
        MacroBase macro = MacroManager.getMacro(result);
        if (macro == null) {
            reader.setCursor(start);
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("Macro '" + result + "' doesn't exist!"))).create();
        }
        return macro;
    }

    public String toString() {
        return "macro()";
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        ArrayList macroNamesList = new ArrayList();
        MacroManager.getMacros().forEach(macro -> macroNamesList.add(macro.getName()));
        macroNamesList.sort(String.CASE_INSENSITIVE_ORDER);
        return class_2172.method_9265(macroNamesList, (SuggestionsBuilder)builder);
    }
}

