/*
 * Decompiled with CFR 0.152.
 */
package tools.redstone.redstonetools.features.toggleable;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public abstract class ClientToggleableFeature {
    private final ConfigBoolean enabled;

    protected ClientToggleableFeature(ConfigBoolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled.getBooleanValue();
    }

    public int toggle(CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
        return this.toggle((FabricClientCommandSource)context.getSource());
    }

    public int toggle(FabricClientCommandSource source) throws CommandSyntaxException {
        return !this.enabled.getBooleanValue() ? this.enable(source) : this.disable(source);
    }

    public void setEnabled(boolean status) {
        if (status == this.enabled.getBooleanValue()) {
            return;
        }
        if (status) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void enable() {
        this.enabled.setBooleanValue(true);
        this.onEnable();
    }

    public int enable(FabricClientCommandSource source) throws CommandSyntaxException {
        this.enable();
        source.getPlayer().method_7353((class_2561)class_2561.method_43470((String)"Enabled %s".formatted(this.getClass().getSimpleName().replace("Feature", ""))), false);
        return 0;
    }

    public void disable() {
        this.enabled.setBooleanValue(false);
        this.onDisable();
    }

    public int disable(FabricClientCommandSource source) throws CommandSyntaxException {
        this.disable();
        source.getPlayer().method_7353((class_2561)class_2561.method_43470((String)"Disabled %s".formatted(this.getClass().getSimpleName().replace("Feature", ""))), false);
        return 0;
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }
}

