/*
 * Decompiled with CFR 0.152.
 */
package tools.redstone.redstonetools.features.toggleable;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import tools.redstone.redstonetools.packets.SetFeatureEnabledPayload;

public abstract class ToggleableFeature {
    private final Set<UUID> enabledFor = new HashSet<UUID>();

    public boolean isEnabled(class_3222 player) {
        return this.enabledFor.contains(player.method_5667());
    }

    public int toggle(CommandContext<class_2168> context) throws CommandSyntaxException {
        return this.toggle((class_2168)context.getSource());
    }

    public int toggle(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        return !this.enabledFor.contains(player.method_5667()) ? this.enable(source) : this.disable(source);
    }

    public void setEnabled(boolean status, class_3222 player) {
        if (status) {
            this.enable(player);
        } else {
            this.disable(player);
        }
    }

    public void enable(class_3222 player) {
        this.enabledFor.add(player.method_5667());
        SetFeatureEnabledPayload payload = new SetFeatureEnabledPayload(this.getName(), true);
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        this.onEnable();
    }

    public int enable(class_2168 source) throws CommandSyntaxException {
        this.enable(source.method_9207());
        source.method_45068((class_2561)class_2561.method_43470((String)("Enabled " + this.getName())));
        return 0;
    }

    public void disable(class_3222 player) {
        this.enabledFor.remove(player.method_5667());
        SetFeatureEnabledPayload payload = new SetFeatureEnabledPayload(this.getName(), false);
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        this.onDisable();
    }

    public int disable(class_2168 source) throws CommandSyntaxException {
        this.disable(source.method_9207());
        source.method_45068((class_2561)class_2561.method_43470((String)("Disabled " + this.getName())));
        return 0;
    }

    public abstract String getName();

    protected void onEnable() {
    }

    protected void onDisable() {
    }
}

