/*
 * Decompiled with CFR 0.152.
 */
package tools.redstone.redstonetools.malilib.widget.macro;

import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.event.InputEventHandler;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import fi.dy.masa.malilib.hotkeys.IKeyboardInputHandler;
import fi.dy.masa.malilib.hotkeys.IMouseInputHandler;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import tools.redstone.redstonetools.macros.actions.Action;
import tools.redstone.redstonetools.macros.actions.CommandAction;
import tools.redstone.redstonetools.malilib.KeybindHandler;
import tools.redstone.redstonetools.malilib.config.MacroManager;

@Environment(value=EnvType.CLIENT)
public class MacroBase {
    public ConfigHotkey hotkey;
    public boolean muted;
    protected String name;
    protected boolean enabled;
    public KeybindHandler handler;
    public List<CommandAction> actions;
    private final AtomicInteger layers = new AtomicInteger(0);

    public MacroBase(String name, String keybind, List<CommandAction> actions) {
        this(name, keybind, actions, true, false);
    }

    public MacroBase(String name, String keybind, List<CommandAction> actions, boolean enabled, boolean muted) {
        this.actions = new ArrayList<CommandAction>(actions);
        this.hotkey = new ConfigHotkey("Hotkey", keybind, KeybindSettings.PRESS_ALLOWEXTRA, "Pressing this hotkey will activate the macro");
        this.hotkey.getKeybind().setCallback((t, g) -> {
            this.run();
            return true;
        });
        this.name = name;
        this.enabled = enabled;
        this.muted = muted;
        this.handler = new KeybindHandler(this);
        InputEventHandler.getKeybindManager().registerKeybindProvider((IKeybindProvider)this.handler);
        InputEventHandler.getInputManager().registerKeyboardInputHandler((IKeyboardInputHandler)this.handler);
        InputEventHandler.getInputManager().registerMouseInputHandler((IMouseInputHandler)this.handler);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void run() {
        if (this.muted) {
            MacroManager.shouldMute = true;
        }
        if (!this.enabled) {
            return;
        }
        if (this.layers.getAndSet(this.layers.get() + 1) > 100) {
            class_310.method_1551().field_1724.method_7353(class_2561.method_30163((String)"Please don't cause a stackoverflow :("), false);
            return;
        }
        try {
            for (Action action : this.actions) {
                action.run();
            }
        }
        catch (StackOverflowError ignored) {
            try {
                class_310.method_1551().field_1724.method_7353(class_2561.method_30163((String)"Please don't cause a stackoverflow :("), false);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw new InternalError("Something has gone terribly wrong. Shouldn't have run a macro that runs itself.", noClassDefFoundError);
            }
        }
        finally {
            this.layers.set(0);
        }
        if (this.muted) {
            MacroManager.shouldMute = false;
        }
    }
}

