/*
 * Decompiled with CFR 0.152.
 */
package tools.redstone.redstonetools.utils;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import tools.redstone.redstonetools.utils.BlockColor;

public class ColoredBlock {
    private static final Pattern COLORED_BLOCK_REGEX = Pattern.compile("^minecraft:(\\w+?)_(wool|stained_glass|concrete_powder|concrete|glazed_terracotta|terracotta)$");
    private static final HashMap<String, ColoredBlock> COLORLESS_BLOCKS = new HashMap<String, ColoredBlock>(){
        {
            this.put("minecraft:glass", new ColoredBlock("minecraft:%s_stained_glass", BlockColor.WHITE));
            this.put("minecraft:terracotta", new ColoredBlock("minecraft:%s_terracotta", BlockColor.WHITE));
        }
    };
    private static final HashMap<String, ColoredBlock> COLORED_BLOCK_CACHE = new HashMap<String, ColoredBlock>(){
        {
            this.putAll(COLORLESS_BLOCKS);
        }
    };
    private final String blockIdFormat;
    public final BlockColor color;

    public ColoredBlock(String blockIdFormat, BlockColor color) {
        this.blockIdFormat = blockIdFormat;
        this.color = color;
    }

    public ColoredBlock withColor(BlockColor color) {
        return new ColoredBlock(this.blockIdFormat, color);
    }

    public static ColoredBlock fromBlockId(String blockId) {
        if (COLORED_BLOCK_CACHE.containsKey(blockId)) {
            return COLORED_BLOCK_CACHE.get(blockId);
        }
        Matcher matcher = COLORED_BLOCK_REGEX.matcher(blockId);
        if (!matcher.matches()) {
            return null;
        }
        String color = matcher.group(1);
        String blockType = matcher.group(2);
        ColoredBlock coloredBlock = new ColoredBlock("minecraft:%s_" + blockType, BlockColor.fromString(color));
        COLORED_BLOCK_CACHE.put(blockId, coloredBlock);
        return coloredBlock;
    }

    public String toBlockId() {
        return String.format(this.blockIdFormat, new Object[]{this.color});
    }

    public static ColoredBlock fromBlock(@NotNull class_2248 block) {
        String blockId = class_7923.field_41175.method_10221((Object)block).toString();
        if (COLORED_BLOCK_CACHE.containsKey(blockId)) {
            return COLORED_BLOCK_CACHE.get(blockId);
        }
        ColoredBlock coloredBlock = ColoredBlock.fromBlockId(blockId);
        COLORED_BLOCK_CACHE.put(blockId, coloredBlock);
        return coloredBlock;
    }

    public class_2248 toBlock() {
        return (class_2248)class_7923.field_41175.method_63535(class_2960.method_12829((String)this.toBlockId()));
    }

    public String toString() {
        return this.toBlockId();
    }
}

