/*
 * Decompiled with CFR 0.152.
 */
package tools.redstone.redstonetools.utils;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class GuiUtils {
    public static List<Layout> betterGetWidgetLayout(List<MinMaxLayout> widgets, double spacing, double totalWidth, boolean includeEdgeSpacing, double edgeSpacing, double y, double height) {
        int i;
        double totalEdgeSpacing;
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        if (widgets == null || widgets.isEmpty()) {
            return layouts;
        }
        int n = widgets.size();
        double totalBetweenSpacing = Math.max(0.0, (double)(n - 1) * spacing);
        double totalSpacing = totalBetweenSpacing + (totalEdgeSpacing = includeEdgeSpacing ? 2.0 * edgeSpacing : 0.0);
        double availableForWidgets = totalWidth - totalSpacing;
        if (availableForWidgets < 0.0) {
            availableForWidgets = 0.0;
        }
        double[] min = new double[n];
        double[] max = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            MinMaxLayout mm = widgets.get(i2);
            min[i2] = mm.minWidth() == -1 ? 0.0 : (double)mm.minWidth();
            double d = max[i2] = mm.maxWidth() == -1 ? Double.POSITIVE_INFINITY : (double)mm.maxWidth();
            if (!(max[i2] < min[i2])) continue;
            max[i2] = min[i2];
        }
        double[] widths = new double[n];
        double sumMin = 0.0;
        for (int i3 = 0; i3 < n; ++i3) {
            widths[i3] = min[i3];
            sumMin += min[i3];
        }
        double remaining = availableForWidgets - sumMin;
        if (remaining > 1.0E-9) {
            boolean[] finished = new boolean[n];
            int unfinishedCount = 0;
            for (i = 0; i < n; ++i) {
                boolean bl = finished[i] = max[i] <= widths[i];
                if (finished[i]) continue;
                ++unfinishedCount;
            }
            while (remaining > 1.0E-9 && unfinishedCount > 0) {
                double share = remaining / (double)unfinishedCount;
                boolean madeProgress = false;
                for (int i4 = 0; i4 < n; ++i4) {
                    if (finished[i4]) continue;
                    double canGrow = max[i4] - widths[i4];
                    if (Double.isInfinite(canGrow) || canGrow > share) {
                        int n2 = i4;
                        widths[n2] = widths[n2] + share;
                        remaining -= share;
                    } else {
                        int n3 = i4;
                        widths[n3] = widths[n3] + canGrow;
                        remaining -= canGrow;
                        finished[i4] = true;
                        --unfinishedCount;
                    }
                    madeProgress = true;
                }
                if (madeProgress) continue;
                break;
            }
        }
        double xCursor = includeEdgeSpacing ? edgeSpacing : 0.0;
        for (i = 0; i < n; ++i) {
            int xi = (int)Math.round(xCursor);
            int yi = (int)Math.round(y);
            int wi = Math.max(0, (int)Math.round(widths[i]));
            int hi = (int)Math.round(height);
            layouts.add(new Layout(xi, yi, wi, hi));
            xCursor += widths[i] + spacing;
        }
        return layouts;
    }

    @Environment(value=EnvType.CLIENT)
    public record MinMaxLayout(int minWidth, int maxWidth, int minHeight, int maxHeight) {
        @Override
        @NotNull
        public String toString() {
            return "MinMaxLayout{minWidth=" + this.minWidth + ", maxWidth " + this.maxWidth + ", minHeight=" + this.minHeight + ", maxHeight=" + this.maxHeight + "}";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            int width;
            int n;
            if (!(obj instanceof MinMaxLayout)) return obj.equals(this);
            MinMaxLayout minMaxLayout = (MinMaxLayout)obj;
            try {
                width = n = minMaxLayout.minWidth();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            int width1 = n = minMaxLayout.maxWidth();
            int height = n = minMaxLayout.minHeight();
            int height1 = n = minMaxLayout.maxHeight();
            if (height != this.maxHeight) return false;
            if (width != this.maxWidth) return false;
            if (height1 != this.minHeight) return false;
            if (width1 != this.minWidth) return false;
            return true;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record Layout(int x, int y, int width, int height) {
        @Override
        @NotNull
        public String toString() {
            return "Layout{x=" + this.x + ", y= " + this.y + ", width=" + this.width + ", height=" + this.height + "}";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            int x1;
            int n;
            if (!(obj instanceof Layout)) return obj.equals(this);
            Layout layout = (Layout)obj;
            try {
                x1 = n = layout.x();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            int y1 = n = layout.y();
            int width1 = n = layout.width();
            int height1 = n = layout.height();
            if (x1 != this.x) return false;
            if (y1 != this.y) return false;
            if (height1 != this.height) return false;
            if (width1 != this.width) return false;
            return true;
        }
    }
}

