/*
 * Decompiled with CFR 0.152.
 */
package tools.redstone.redstonetools.utils;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_9279;
import net.minecraft.class_9288;
import net.minecraft.class_9334;

@FunctionalInterface
public interface SignalBlockSupplier {
    public class_1799 createItem(int var1);

    default public class_1799 getItemStack(class_2248 ignoredBlock, int signalStrength) {
        class_1799 item = this.createItem(signalStrength);
        SignalBlockSupplier.setItemName(item, signalStrength);
        item.method_57379(class_9334.field_49641, (Object)true);
        return item;
    }

    public static SignalBlockSupplier container(int slots, class_1792 containerType) {
        return signalStrength -> {
            if (SignalBlockSupplier.isInvalidSignalStrength(signalStrength, 1387)) {
                throw new IllegalArgumentException("Container signal must be 0-1387");
            }
            class_1792 item = SignalBlockSupplier.getBestItem(signalStrength, slots);
            int stackSize = SignalBlockSupplier.getStackSize(signalStrength, item);
            int itemsNeeded = SignalBlockSupplier.getItemsNeeded(slots, signalStrength, item);
            class_1799 stack = new class_1799((class_1935)containerType);
            class_2371 inventoryItems = class_2371.method_10213((int)slots, (Object)class_1799.field_8037);
            int slot = 0;
            for (int count = itemsNeeded; count > 0; count -= stackSize) {
                inventoryItems.set(slot, (Object)new class_1799((class_1935)item, Math.min(stackSize, count)));
                ++slot;
            }
            class_9288 containerComponent = class_9288.method_57493((List)inventoryItems);
            stack.method_57379(class_9334.field_49622, (Object)containerComponent);
            return stack;
        };
    }

    private static int getItemsNeeded(int slots, int signalStrength, class_1792 item) {
        int itemsNeeded = Math.max(0, signalStrength == 1 ? 1 : (int)Math.ceil((double)(slots * (signalStrength - 1)) / 14.0 * (double)item.method_7882()));
        if (SignalBlockSupplier.calculateComparatorOutput(itemsNeeded, slots, item.method_7882()) != signalStrength) {
            throw new IllegalStateException("This signal strength cannot be achieved with the selected container");
        }
        return itemsNeeded;
    }

    public static SignalBlockSupplier commandBlock() {
        return signalStrength -> {
            if (SignalBlockSupplier.isInvalidSignalStrength(signalStrength, Integer.MAX_VALUE)) {
                throw new IllegalArgumentException("Command block signal must be positive");
            }
            class_1799 commandBlockStack = new class_1799((class_1935)class_1802.field_8866);
            class_2487 blockEntityNbt = new class_2487();
            blockEntityNbt.method_10569("SuccessCount", signalStrength);
            class_9279 blockEntityData = class_9279.method_57456((class_2487)blockEntityNbt);
            commandBlockStack.method_57379(class_9334.field_49628, (Object)blockEntityData);
            return commandBlockStack;
        };
    }

    private static boolean isInvalidSignalStrength(int signalStrength, int maxSignalStrength) {
        return signalStrength < 0 || signalStrength > maxSignalStrength;
    }

    private static int calculateComparatorOutput(int items, int slots, int item$getMaxCount) {
        float f = (float)items / (float)item$getMaxCount;
        return class_3532.method_15375((float)(f / (float)slots * 14.0f)) + (items > 0 ? 1 : 0);
    }

    private static class_1792 getBestItem(int signalStrength, int slots) {
        if (signalStrength > 15) {
            return class_1802.field_8722;
        }
        if (slots >= 15) {
            return class_1802.field_8876;
        }
        return class_1802.field_8600;
    }

    private static int getStackSize(int signalStrength, class_1792 item) {
        if (signalStrength > 897) {
            return 99;
        }
        if (signalStrength > 15) {
            return 64;
        }
        return item.method_7882();
    }

    private static void setItemName(class_1799 item, int signalStrength) {
        class_5250 text = class_2561.method_43470((String)String.valueOf(signalStrength));
        text.method_10862(text.method_10866().method_10977(class_124.field_1061));
        item.method_57379(class_9334.field_49631, (Object)text);
    }
}

