/*
 * Decompiled with CFR 0.152.
 */
package tools.redstone.redstonetools.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import tools.redstone.redstonetools.features.commands.ClientDataFeature;
import tools.redstone.redstonetools.malilib.config.Configs;
import tools.redstone.redstonetools.utils.MathUtils;

@Environment(value=EnvType.CLIENT)
public class StringUtils {
    public static List<String> unmodifiedCommand = new ArrayList<String>();

    public static String insertVariablesAndMath(String command) {
        int counter = 0;
        String prevCommand = "";
        while (!prevCommand.equals(command)) {
            prevCommand = command;
            if (counter++ > 10000) {
                return command;
            }
            Pattern pattern = Pattern.compile(Pattern.quote(Configs.ClientData.MATH_BEGIN_STRING.getStringValue()) + "(.*?)" + Pattern.quote(Configs.ClientData.MATH_END_STRING.getStringValue()));
            Matcher matcher = pattern.matcher(command);
            StringBuilder result = new StringBuilder();
            boolean mathReplaced = false;
            while (matcher.find()) {
                String insideBraces = matcher.group(1);
                try {
                    String replacement = MathUtils.handleMat(insideBraces);
                    matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
                }
                catch (IllegalArgumentException replacement) {
                    // empty catch block
                }
                mathReplaced = true;
            }
            matcher.appendTail(result);
            if (mathReplaced) {
                command = result.toString();
            }
            for (String str : ClientDataFeature.INSTANCE.variables.keySet()) {
                String toReplace;
                String key = Configs.ClientData.VARIABLE_BEGIN_STRING.getStringValue() + str + Configs.ClientData.VARIABLE_END_STRING.getStringValue();
                if (!command.contains(key) || command.contains("\\" + key) || (toReplace = ClientDataFeature.INSTANCE.variables.get(str)) == null || toReplace.isEmpty()) continue;
                command = command.replaceAll(Pattern.quote(key), toReplace);
            }
        }
        for (String str : ClientDataFeature.INSTANCE.variables.keySet()) {
            String key = Configs.ClientData.VARIABLE_BEGIN_STRING.getStringValue() + str + Configs.ClientData.VARIABLE_END_STRING.getStringValue();
            if (!command.contains("\\" + key)) continue;
            command = command.replaceAll(Pattern.quote("\\" + key), key);
        }
        return command;
    }

    public static String expand(String shortStr, String expandedString) {
        Pattern tokenPattern = Pattern.compile("'([^']*)'");
        Pattern quotedValuePattern = Pattern.compile("^'([^']*)'$");
        Matcher tokenMatcher = tokenPattern.matcher(shortStr);
        String result = expandedString;
        while (tokenMatcher.find()) {
            String resolved;
            String tokenWithQuotes;
            block4: {
                String val;
                tokenWithQuotes = tokenMatcher.group(0);
                String key = tokenMatcher.group(1);
                HashSet<String> seen = new HashSet<String>();
                String currentKey = key;
                while (true) {
                    if (!seen.add(currentKey)) {
                        resolved = null;
                        break block4;
                    }
                    val = ClientDataFeature.INSTANCE.variables.get(currentKey);
                    if (val == null) {
                        resolved = null;
                        break block4;
                    }
                    Matcher qm = quotedValuePattern.matcher(val);
                    if (!qm.matches()) break;
                    currentKey = qm.group(1);
                }
                resolved = val;
            }
            if (resolved == null || resolved.isEmpty()) continue;
            result = result.replaceFirst(Pattern.quote(resolved), Matcher.quoteReplacement(tokenWithQuotes));
        }
        return result;
    }
}

