/*
 * Decompiled with CFR 0.152.
 */
package tools.redstone.redstonetools.features.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.math.BigInteger;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public class BaseConvertFeature {
    public static final BaseConvertFeature INSTANCE = new BaseConvertFeature();
    private static final SimpleCommandExceptionType INVALID_NUMBER = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Invalid number"));

    protected BaseConvertFeature() {
    }

    public void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"base").then(class_2170.method_9244((String)"inputNum", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"toBase", (ArgumentType)IntegerArgumentType.integer((int)2, (int)16)).executes(context -> INSTANCE.execute(StringArgumentType.getString((CommandContext)context, (String)"inputNum"), IntegerArgumentType.getInteger((CommandContext)context, (String)"toBase"), t -> {
            try {
                ((class_2168)context.getSource()).method_9207().method_64398(t);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        })))));
    }

    protected int execute(String number, int toBase, Consumer<class_2561> printToChat) throws CommandSyntaxException {
        BigInteger integer;
        int base = 10;
        number = number.toLowerCase(Locale.ROOT);
        String prefix = "";
        if (number.startsWith("0x")) {
            prefix = "0x";
            base = 16;
        } else if (number.startsWith("0o")) {
            prefix = "0o";
            base = 8;
        } else if (number.startsWith("0b")) {
            prefix = "0b";
            base = 2;
        }
        if (base != 10) {
            number = number.substring(2);
        }
        try {
            integer = new BigInteger(number, base);
        }
        catch (NumberFormatException e) {
            throw INVALID_NUMBER.create();
        }
        String output = integer.toString(toBase).toLowerCase(Locale.ROOT);
        String toPrefix = "";
        if (toBase == 16) {
            toPrefix = "0x";
        } else if (toBase == 8) {
            toPrefix = "0o";
        } else if (toBase == 2) {
            toPrefix = "0b";
        }
        if (!toPrefix.isEmpty()) {
            printToChat.accept((class_2561)class_2561.method_43470((String)"%s = %s".formatted(prefix + number, toPrefix + output)));
        } else {
            printToChat.accept((class_2561)class_2561.method_43470((String)"%s = %s in base %s".formatted(prefix + number, output, toBase)));
        }
        return 1;
    }
}

