/*
 * Decompiled with CFR 0.152.
 */
package tools.redstone.redstonetools.features.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2257;
import net.minecraft.class_2338;
import net.minecraft.class_2453;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_7157;
import tools.redstone.redstonetools.utils.WorldEditUtils;

public class BinaryBlockReadFeature {
    public static final BinaryBlockReadFeature INSTANCE = new BinaryBlockReadFeature();

    protected BinaryBlockReadFeature() {
    }

    public void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"/read").requires(source -> source.method_9259(2))).executes(this.getCommandForArgumentCount(0))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"offset", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(this.getCommandForArgumentCount(1))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"onBlock", (ArgumentType)class_2257.method_9653((class_7157)registryAccess)).executes(this.getCommandForArgumentCount(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"toBase", (ArgumentType)IntegerArgumentType.integer((int)2, (int)16)).executes(this.getCommandForArgumentCount(3))).then(class_2170.method_9244((String)"reverseBits", (ArgumentType)BoolArgumentType.bool()).executes(this.getCommandForArgumentCount(4)))))));
    }

    protected Command<class_2168> getCommandForArgumentCount(int argNum) {
        return context -> this.execute((CommandContext<class_2168>)context, argNum);
    }

    protected int execute(CommandContext<class_2168> context, int argCount) throws CommandSyntaxException {
        int offset = argCount >= 1 ? IntegerArgumentType.getInteger(context, (String)"offset") : 2;
        class_2680 onBlock = argCount >= 2 ? class_2257.method_9655(context, (String)"onBlock").method_9494() : (class_2680)class_2246.field_10524.method_9564().method_11657((class_2769)class_2453.field_11413, (Comparable)Boolean.valueOf(true));
        int toBase = argCount >= 3 ? IntegerArgumentType.getInteger(context, (String)"toBase") : 10;
        boolean reverseBits = argCount >= 4 && BoolArgumentType.getBool(context, (String)"reverseBits");
        return this.execute(context, offset, onBlock, toBase, reverseBits);
    }

    protected int execute(CommandContext<class_2168> context, int offset, class_2680 onBlock, int toBase, boolean reverseBits) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        Region selection = WorldEditUtils.getSelection(source.method_44023());
        CuboidRegion boundingBox = selection.getBoundingBox();
        BlockVector3 pos1 = boundingBox.getPos1();
        BlockVector3 pos2 = boundingBox.getPos2();
        BlockVector3 direction = pos2.subtract(pos1).normalize();
        if (direction.lengthSq() == 0) {
            direction = BlockVector3.at((int)0, (int)0, (int)1);
        }
        BlockVector3 spacingVector = direction.multiply(offset);
        if (direction.x() + direction.y() + direction.z() > 1) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_30163((String)"The selection must have 2 axis the same.")).create();
        }
        StringBuilder bits = new StringBuilder();
        BlockVector3 point = pos1;
        while (boundingBox.contains(point)) {
            class_2338 pos = new class_2338(point.x(), point.y(), point.z());
            class_2680 actualState = source.method_9225().method_8320(pos);
            boolean matches = actualState.equals(onBlock) && actualState.method_11656().equals(onBlock.method_11656());
            bits.append(matches ? 1 : 0);
            point = point.add(spacingVector);
        }
        if (reverseBits) {
            bits.reverse();
        }
        String output = Integer.toString(Integer.parseInt(bits.toString(), 2), toBase);
        source.method_45068(class_2561.method_30163((String)output));
        return 0;
    }
}

