/*
 * Decompiled with CFR 0.152.
 */
package tools.redstone.redstonetools.features.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.fabric.FabricAdapter;
import com.sk89q.worldedit.fabric.FabricPlayer;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Mask2D;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import org.jetbrains.annotations.Nullable;
import tools.redstone.redstonetools.utils.ArgumentUtils;
import tools.redstone.redstonetools.utils.BlockColor;
import tools.redstone.redstonetools.utils.ColoredBlock;
import tools.redstone.redstonetools.utils.PlayerUtils;
import tools.redstone.redstonetools.utils.WorldEditUtils;

public class ColorCodeFeature {
    public static final ColorCodeFeature INSTANCE = new ColorCodeFeature();
    public BlockColor color;
    public BlockColor onlyColor;

    protected ColorCodeFeature() {
    }

    public void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"/colorcode").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"color", (ArgumentType)StringArgumentType.string()).suggests(ArgumentUtils.BLOCK_COLOR_SUGGESTION_PROVIDER).executes(this::execute)).then(class_2170.method_9244((String)"onlyColor", (ArgumentType)StringArgumentType.string()).suggests(ArgumentUtils.BLOCK_COLOR_SUGGESTION_PROVIDER).executes(this::execute))));
    }

    private boolean shouldBeColored(World world, BlockVector3 pos, BlockColor onlyColor) {
        BlockState state = world.getBlock(pos);
        String blockId = state.getBlockType().id();
        ColoredBlock coloredBlock = ColoredBlock.fromBlockId(blockId);
        if (coloredBlock == null) {
            return false;
        }
        if (onlyColor == null) {
            return true;
        }
        BlockColor blockColor = coloredBlock.color;
        return blockColor == onlyColor;
    }

    private BaseBlock getColoredBlock(World world, BlockVector3 pos, BlockColor color) {
        BlockState state = world.getBlock(pos);
        String blockId = state.getBlockType().id();
        ColoredBlock coloredBlock = ColoredBlock.fromBlockId(blockId);
        if (coloredBlock == null) {
            return state.toBaseBlock();
        }
        BlockType blockType = (BlockType)BlockType.REGISTRY.get(coloredBlock.withColor(color).toBlockId());
        assert (blockType != null);
        return blockType.getDefaultState().toBaseBlock();
    }

    protected int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        this.color = ArgumentUtils.parseBlockColor(context, "color");
        try {
            this.onlyColor = ArgumentUtils.parseBlockColor(context, "onlyColor");
        }
        catch (Exception ignored) {
            this.onlyColor = null;
        }
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        Region selection = WorldEditUtils.getSelection(player);
        WorldEdit worldEdit = WorldEdit.getInstance();
        assert (player != null);
        FabricPlayer wePlayer = FabricAdapter.adaptPlayer((class_3222)player);
        LocalSession playerSession = worldEdit.getSessionManager().get((SessionOwner)wePlayer);
        final World world = FabricAdapter.adapt((class_1937)PlayerUtils.getWorld((class_1297)player));
        try (EditSession session = worldEdit.newEditSession(world);){
            int blocksColored = session.replaceBlocks(selection, new Mask(){

                public boolean test(BlockVector3 vector) {
                    return ColorCodeFeature.this.shouldBeColored(world, vector, ColorCodeFeature.this.onlyColor);
                }

                @Nullable
                public Mask2D toMask2D() {
                    return null;
                }
            }, new Pattern(){

                public BaseBlock applyBlock(BlockVector3 position) {
                    return ColorCodeFeature.this.getColoredBlock(world, position, ColorCodeFeature.this.color);
                }
            });
            Operations.complete((Operation)session.commit());
            playerSession.remember(session);
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Successfully colored %s block(s) %s.".formatted(new Object[]{blocksColored, this.color})));
        }
        catch (Exception e) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"An error occurred while coloring the block(s).")).create();
        }
        return 1;
    }
}

