/*
 * Decompiled with CFR 0.152.
 */
package tools.redstone.redstonetools.features.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import tools.redstone.redstonetools.utils.ItemUtils;

public class ItemBindFeature {
    public static final ItemBindFeature INSTANCE = new ItemBindFeature();
    public static ArrayList<class_3222> playersWaitingForCommand = new ArrayList();

    protected ItemBindFeature() {
    }

    public void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"itembind").requires(source -> source.method_9259(2))).executes(this::execute)).then(class_2170.method_9247((String)"reset").executes(ItemBindFeature::executeReset)));
    }

    private static int executeReset(CommandContext<class_2168> context) {
        boolean mainhand;
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        if (ItemUtils.containsCommand(player.method_6047())) {
            mainhand = true;
        } else if (ItemUtils.containsCommand(player.method_6079())) {
            mainhand = false;
        } else {
            ((class_2168)context.getSource()).method_44023().method_7353(class_2561.method_30163((String)"You need to be holding an item with a command in one of your hands!"), false);
            return 0;
        }
        class_1799 stack = mainhand ? player.method_6047() : player.method_6079();
        ItemUtils.removeCommand(stack);
        stack.method_57379(class_9334.field_49632, (Object)((class_9290)stack.method_7909().method_7854().method_57824(class_9334.field_49632)));
        ((class_2168)context.getSource()).method_44023().method_7353(class_2561.method_30163((String)("Successfully removed command from the item in your " + (mainhand ? "mainhand" : "offhand"))), false);
        return 1;
    }

    protected int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        playersWaitingForCommand.add(source.method_44023());
        source.method_45068((class_2561)class_2561.method_43470((String)"Please run any command and hold the item you want the command be bound to in your main hand"));
        return 1;
    }

    public static void addCommand(String command, class_3222 playerI) {
        if (!ItemBindFeature.waitingForCommandForPlayer(playerI)) {
            return;
        }
        class_1799 stack = playerI.method_6047();
        if (stack.method_7960()) {
            if (playerI.method_6079().method_7960()) {
                playerI.method_64398((class_2561)class_2561.method_43470((String)"You need to be holding an item!"));
                return;
            }
            stack = playerI.method_6079();
        }
        ItemUtils.setCommand(stack, command);
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(class_2561.method_30163((String)("Has command: /" + command)))));
        playersWaitingForCommand.remove(playerI);
        playerI.method_7353((class_2561)class_2561.method_43470((String)"Successfully bound command: '/%s' to this item (%s)!".formatted(command, stack.method_7909().method_63680().getString())), false);
    }

    public static boolean waitingForCommandForPlayer(class_3222 player1) {
        return playersWaitingForCommand.contains(player1);
    }
}

