/*
 * Decompiled with CFR 0.152.
 */
package tools.redstone.redstonetools.features.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.fabric.FabricAdapter;
import com.sk89q.worldedit.fabric.FabricPlayer;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import tools.redstone.redstonetools.utils.WorldEditUtils;

public class MinSelectionFeature {
    public static final MinSelectionFeature INSTANCE = new MinSelectionFeature();

    protected MinSelectionFeature() {
    }

    public void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"/minsel").requires(source -> source.method_9259(2))).executes(this::execute));
    }

    protected int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        Region selection = WorldEditUtils.getSelection(((class_2168)context.getSource()).method_44023());
        World selectionWorld = selection.getWorld();
        FabricPlayer actor = FabricAdapter.adaptPlayer((class_3222)Objects.requireNonNull(((class_2168)context.getSource()).method_44023()));
        LocalSession localSession = WorldEdit.getInstance().getSessionManager().get((SessionOwner)actor);
        RegionSelector selector = localSession.getRegionSelector(selectionWorld);
        assert (selectionWorld != null);
        assert (BlockTypes.AIR != null);
        boolean isEmpty = true;
        for (BlockVector3 point : selection) {
            if (selectionWorld.getBlock(point).equals((Object)BlockTypes.AIR.getDefaultState())) continue;
            isEmpty = false;
        }
        if (isEmpty) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_30163((String)"Cannot minimize empty selections.")).create();
        }
        this.minimiseSelection(selectionWorld, selection);
        selector.learnChanges();
        selector.explainRegionAdjust((Actor)actor, localSession);
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Minimized selection."));
        return 1;
    }

    private void minimiseSelection(World selectionWorld, Region selection) throws CommandSyntaxException {
        ArrayList<BlockVector3> changes = new ArrayList<BlockVector3>();
        List<CuboidRegion> faces = this.getFaces(selection);
        boolean finished = true;
        for (CuboidRegion face : faces) {
            boolean isOnlyAir = true;
            for (BlockVector3 point : face) {
                assert (BlockTypes.AIR != null);
                if (selectionWorld.getBlock(point).getBlockType().getDefaultState() == BlockTypes.AIR.getDefaultState()) continue;
                isOnlyAir = false;
                break;
            }
            if (!isOnlyAir) continue;
            Vector3 difference = selection.getCenter().subtract(face.getCenter());
            difference = difference.normalize();
            changes.add(difference.toBlockPoint());
            finished = false;
        }
        try {
            selection.contract(changes.toArray(new BlockVector3[0]));
        }
        catch (RegionOperationException e) {
            throw new CommandSyntaxException(null, (Message)class_2561.method_43470((String)"There was an error modifying the region."));
        }
        if (!finished) {
            this.minimiseSelection(selectionWorld, selection);
        }
    }

    private List<CuboidRegion> getFaces(Region selection) {
        ArrayList<CuboidRegion> faces = new ArrayList<CuboidRegion>();
        BlockVector3 pos1 = selection.getBoundingBox().getPos1();
        BlockVector3 pos2 = selection.getBoundingBox().getPos2();
        BlockVector3 min = selection.getMinimumPoint();
        BlockVector3 max = selection.getMaximumPoint();
        faces.add(new CuboidRegion(pos1.withX(min.x()), pos2.withX(min.x())));
        faces.add(new CuboidRegion(pos1.withX(max.x()), pos2.withX(max.x())));
        faces.add(new CuboidRegion(pos1.withZ(min.z()), pos2.withZ(min.z())));
        faces.add(new CuboidRegion(pos1.withZ(max.z()), pos2.withZ(max.z())));
        faces.add(new CuboidRegion(pos1.withY(min.y()), pos2.withY(min.y())));
        faces.add(new CuboidRegion(pos1.withY(max.y()), pos2.withY(max.y())));
        return faces;
    }
}

