/*
 * Decompiled with CFR 0.152.
 */
package tools.redstone.redstonetools.features.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.fabric.FabricAdapter;
import com.sk89q.worldedit.fabric.FabricPlayer;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Mask2D;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.World;
import java.util.Objects;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import org.jetbrains.annotations.Nullable;
import tools.redstone.redstonetools.utils.ArgumentUtils;
import tools.redstone.redstonetools.utils.DirectionArgument;
import tools.redstone.redstonetools.utils.DirectionUtils;

public class RStackFeature {
    public static final RStackFeature INSTANCE = new RStackFeature();

    protected RStackFeature() {
    }

    public void registerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"/rstack").requires(source -> source.method_9259(2))).executes(this.getCommandForArgumentCount(0))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(this.getCommandForArgumentCount(1))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"direction", (ArgumentType)StringArgumentType.string()).suggests(ArgumentUtils.DIRECTION_SUGGESTION_PROVIDER).executes(this.getCommandForArgumentCount(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"offset", (ArgumentType)IntegerArgumentType.integer()).executes(this.getCommandForArgumentCount(3))).then(class_2170.method_9244((String)"moveSelection", (ArgumentType)BoolArgumentType.bool()).executes(this.getCommandForArgumentCount(4)))))));
    }

    protected Command<class_2168> getCommandForArgumentCount(int argNum) {
        return context -> this.execute((CommandContext<class_2168>)context, argNum);
    }

    protected int execute(CommandContext<class_2168> context, int argCount) throws CommandSyntaxException {
        int count = argCount >= 1 ? IntegerArgumentType.getInteger(context, (String)"count") : 1;
        DirectionArgument direction = argCount >= 2 ? ArgumentUtils.parseDirection(context, "direction") : DirectionArgument.ME;
        int offset = argCount >= 3 ? IntegerArgumentType.getInteger(context, (String)"offset") : 2;
        boolean moveSelection = argCount >= 4 && BoolArgumentType.getBool(context, (String)"moveSelection");
        return this.execute(context, count, offset, direction, moveSelection);
    }

    protected int execute(CommandContext<class_2168> context, int count, int offset, DirectionArgument direction, boolean moveSelection) throws CommandSyntaxException {
        Direction stackDirection;
        Region selection;
        FabricPlayer actor = FabricAdapter.adaptPlayer((class_3222)Objects.requireNonNull(((class_2168)context.getSource()).method_44023()));
        LocalSession localSession = WorldEdit.getInstance().getSessionManager().get((SessionOwner)actor);
        final World selectionWorld = localSession.getSelectionWorld();
        assert (selectionWorld != null);
        try {
            selection = localSession.getSelection(selectionWorld);
        }
        catch (IncompleteRegionException ex) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Please make a selection with WorldEdit first.")).create();
        }
        Mask airFilter = new Mask(){

            public boolean test(BlockVector3 vector) {
                return !"minecraft:air".equals(selectionWorld.getBlock(vector).getBlockType().id());
            }

            @Nullable
            public Mask2D toMask2D() {
                return null;
            }
        };
        Direction playerFacing = actor.getLocation().getDirectionEnum();
        try {
            stackDirection = DirectionUtils.matchDirection(direction, playerFacing);
        }
        catch (Exception e) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)e.getMessage().formatted(e))).create();
        }
        BlockVector3 stackVector = DirectionUtils.directionToBlock(stackDirection);
        try (EditSession editSession = localSession.createEditSession((Actor)actor);){
            for (int i = 1; i <= count; ++i) {
                BlockVector3 offsetVector = Objects.requireNonNull(stackVector).multiply(i * offset);
                ForwardExtentCopy copy = new ForwardExtentCopy((Extent)editSession, selection, (Extent)editSession, selection.getMinimumPoint().add(offsetVector));
                copy.setSourceMask(airFilter);
                copy.setSourceFunction(position -> false);
                Operations.complete((Operation)copy);
                if (i != count || !moveSelection) continue;
                selection.shift(offsetVector);
            }
            localSession.remember(editSession);
        }
        catch (WorldEditException e) {
            throw new RuntimeException(e);
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Stacked %s time(s).".formatted(count)));
        return 1;
    }
}

