/*
 * Decompiled with CFR 0.152.
 */
package tools.redstone.redstonetools.malilib.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import tools.redstone.redstonetools.macros.actions.CommandAction;
import tools.redstone.redstonetools.malilib.widget.macro.MacroBase;

@Environment(value=EnvType.CLIENT)
public class MacroManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static boolean shouldMute;
    private static final Path MACROS_FILE_PATH;
    private static List<MacroBase> macros;
    private static final Type MACRO_LIST_TYPE;

    public static List<MacroBase> getAllMacros() {
        return macros;
    }

    public static void saveChanges() {
        ArrayList<MacroStructure> macroStructure = new ArrayList<MacroStructure>();
        for (MacroBase macro : macros) {
            macroStructure.add(new MacroStructure(macro.getName(), macro.hotkey.getKeybind().getStringValue(), macro.isEnabled(), macro.muted, macro.actions));
        }
        try {
            if (MACROS_FILE_PATH.getParent() != null) {
                Files.createDirectories(MACROS_FILE_PATH.getParent(), new FileAttribute[0]);
            }
            Path tmp = MACROS_FILE_PATH.resolveSibling(MACROS_FILE_PATH.getFileName().toString() + ".tmp");
            try (BufferedWriter writer = Files.newBufferedWriter(tmp, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson(macroStructure, MACRO_LIST_TYPE, (Appendable)writer);
            }
            Files.move(tmp, MACROS_FILE_PATH, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void loadMacros() {
        if (!Files.exists(MACROS_FILE_PATH, new LinkOption[0])) {
            macros = MacroManager.getDefaultMacros();
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(MACROS_FILE_PATH, StandardCharsets.UTF_8);){
            List list = (List)GSON.fromJson((Reader)reader, MACRO_LIST_TYPE);
            if (list == null) {
                macros = MacroManager.getDefaultMacros();
                return;
            }
            for (MacroStructure macro : list) {
                macros.add(new MacroBase(macro.name, macro.key, macro.actions, macro.enabled, macro.muted));
            }
        }
        catch (IOException ignored) {
            macros = MacroManager.getDefaultMacros();
        }
    }

    public static List<MacroBase> getMacros() {
        return macros;
    }

    public static MacroBase getMacro(String name) {
        for (MacroBase macro : macros) {
            if (!macro.getName().equals(name)) continue;
            return macro;
        }
        return null;
    }

    public static boolean nameExists(String name, MacroBase exclude) {
        for (MacroBase macro : macros) {
            if (macro == exclude || !macro.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static List<MacroBase> getDefaultMacros() {
        return new ArrayList<MacroBase>(List.of(MacroManager.createCommandMacro("redstoner", new String[]{"/gamerule doTileDrops false", "/gamerule doTraderSpawning false", "/gamerule doWeatherCycle false", "/gamerule doDaylightCycle false", "/gamerule doMobSpawning false", "/gamerule doContainerDrops false", "/time set noon", "/weather clear"}), MacroManager.createCommandMacro("copystate", new String[]{"/copystate"}), MacroManager.createCommandMacro("itembind", new String[]{"/itembind"}), MacroManager.createCommandMacro("minsel", new String[]{"//minsel"}), MacroManager.createCommandMacro("quicktp", new String[]{"/quicktp"}), MacroManager.createCommandMacro("binaryblockread", new String[]{"//binaryblockread"}), MacroManager.createCommandMacro("rstack", new String[]{"//rstack"}), MacroManager.createCommandMacro("update", new String[]{"//update"})));
    }

    public static MacroBase createCommandMacro(String name, String[] commands) {
        CommandAction[] actions = new CommandAction[commands.length];
        for (int i = 0; i < commands.length; ++i) {
            actions[i] = new CommandAction(commands[i]);
        }
        return new MacroBase(name, "", List.of(actions));
    }

    public static void removeMacro(MacroBase macro) {
        macros.remove(macro);
    }

    public static void addMacroToTop(MacroBase macroBase) {
        if (MacroManager.nameExists(macroBase.getName(), null)) {
            macroBase.setName(macroBase.getName() + " " + String.valueOf(UUID.randomUUID()));
        }
        macros.addFirst(macroBase);
    }

    static {
        MACROS_FILE_PATH = class_310.method_1551().field_1697.toPath().resolve("config").resolve("redstonetools").resolve("macros.json");
        macros = new ArrayList<MacroBase>();
        MACRO_LIST_TYPE = new TypeToken<List<MacroStructure>>(){}.getType();
    }

    @Environment(value=EnvType.CLIENT)
    record MacroStructure(String name, String key, boolean enabled, boolean muted, List<CommandAction> actions) {
    }
}

