/*
 * Decompiled with CFR 0.152.
 */
package tools.redstone.redstonetools.malilib.widget.macro;

import fi.dy.masa.malilib.event.InputEventHandler;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListEntryBase;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import fi.dy.masa.malilib.hotkeys.IKeyboardInputHandler;
import fi.dy.masa.malilib.hotkeys.IMouseInputHandler;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import tools.redstone.redstonetools.malilib.GuiMacroEditor;
import tools.redstone.redstonetools.malilib.config.MacroManager;
import tools.redstone.redstonetools.malilib.widget.macro.MacroBase;
import tools.redstone.redstonetools.malilib.widget.macro.WidgetListMacros;

@Environment(value=EnvType.CLIENT)
public class WidgetMacroEntry
extends WidgetListEntryBase<MacroBase> {
    private final WidgetListMacros parent;
    public final MacroBase macro;
    protected final boolean isOdd;
    protected final int buttonsStartX;

    public boolean canSelectAt(int mouseX, int mouseY, int mouseButton) {
        return super.canSelectAt(mouseX, mouseY, mouseButton) && mouseX < this.buttonsStartX;
    }

    public void render(int mouseX, int mouseY, boolean selected, class_332 context) {
        if (selected || this.isMouseOver(mouseX, mouseY)) {
            RenderUtils.drawRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)0x70FFFFFF);
        } else if (this.isOdd) {
            RenderUtils.drawRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)0x20FFFFFF);
        } else {
            RenderUtils.drawRect((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)0x50FFFFFF);
        }
        this.drawString(this.x + 4, this.y + 7, -1, this.macro.getName(), context);
        super.render(mouseX, mouseY, selected, context);
    }

    public void postRenderHovered(int mouseX, int mouseY, boolean selected, class_332 context) {
        super.postRenderHovered(mouseX, mouseY, selected, context);
    }

    public WidgetMacroEntry(int x, int y, int width, int height, boolean isOdd, MacroBase macro, int listIndex, WidgetListMacros parent) {
        super(x, y, width, height, (Object)macro, listIndex);
        this.macro = macro;
        this.isOdd = isOdd;
        this.parent = parent;
        int posX = x + width - 2;
        posX -= this.addButton(posX, ++y, ButtonListener.Type.REMOVE);
        posX -= this.addButton(posX, y, ButtonListener.Type.CONFIGURE);
        this.buttonsStartX = posX;
    }

    protected int addButton(int x, int y, ButtonListener.Type type) {
        ButtonGeneric button = new ButtonGeneric(x, y, -1, true, type.getDisplayName(new Object[0]), new Object[0]);
        this.addButton((ButtonBase)button, new ButtonListener(type, this));
        return button.getWidth() + 1;
    }

    @Environment(value=EnvType.CLIENT)
    private static class ButtonListener
    implements IButtonActionListener {
        private final Type type;
        private final WidgetMacroEntry widget;

        public ButtonListener(Type type, WidgetMacroEntry widget) {
            this.type = type;
            this.widget = widget;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            if (this.type == Type.CONFIGURE) {
                GuiMacroEditor gui = new GuiMacroEditor(class_2561.method_30163((String)this.widget.macro.name), this.widget.macro, this.widget.parent.parent);
                GuiBase.openGui((class_437)gui);
                this.widget.parent.refreshEntries();
            } else if (this.type == Type.REMOVE) {
                InputEventHandler.getKeybindManager().unregisterKeybindProvider((IKeybindProvider)this.widget.macro.handler);
                InputEventHandler.getInputManager().unregisterKeyboardInputHandler((IKeyboardInputHandler)this.widget.macro.handler);
                InputEventHandler.getInputManager().unregisterMouseInputHandler((IMouseInputHandler)this.widget.macro.handler);
                InputEventHandler.getKeybindManager().updateUsedKeys();
                MacroManager.removeMacro(this.widget.macro);
                MacroManager.saveChanges();
                this.widget.parent.refreshEntries();
            }
        }

        @Environment(value=EnvType.CLIENT)
        public static enum Type {
            CONFIGURE("Edit"),
            REMOVE("Remove");

            private final String name;

            private Type(String name) {
                this.name = name;
            }

            public String getDisplayName(Object ... args) {
                return StringUtils.translate((String)this.name, (Object[])args);
            }
        }
    }
}

