/*
 * Decompiled with CFR 0.152.
 */
package tools.redstone.redstonetools.utils;

import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.Direction;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import tools.redstone.redstonetools.utils.DirectionArgument;

public class DirectionUtils {
    public static Direction firstOrdinal(Direction playerFacing) {
        return switch (playerFacing) {
            case Direction.EAST_NORTHEAST, Direction.NORTH_NORTHEAST -> Direction.NORTHEAST;
            case Direction.NORTH_NORTHWEST, Direction.WEST_NORTHWEST -> Direction.NORTHWEST;
            case Direction.EAST_SOUTHEAST, Direction.SOUTH_SOUTHEAST -> Direction.SOUTHEAST;
            case Direction.SOUTH_SOUTHWEST, Direction.WEST_SOUTHWEST -> Direction.SOUTHWEST;
            default -> playerFacing;
        };
    }

    public static DirectionArgument relativeToAbsolute(DirectionArgument direction, Direction playerFacing) throws Exception {
        return switch (direction) {
            case DirectionArgument.ME, DirectionArgument.FORWARD -> {
                switch (DirectionUtils.firstOrdinal(playerFacing)) {
                    case UP: {
                        yield DirectionArgument.UP;
                    }
                    case DOWN: {
                        yield DirectionArgument.DOWN;
                    }
                    case NORTH: {
                        yield DirectionArgument.NORTH;
                    }
                    case EAST: {
                        yield DirectionArgument.EAST;
                    }
                    case SOUTH: {
                        yield DirectionArgument.SOUTH;
                    }
                    case WEST: {
                        yield DirectionArgument.WEST;
                    }
                    case NORTHEAST: {
                        yield DirectionArgument.NORTHEAST;
                    }
                    case NORTHWEST: {
                        yield DirectionArgument.NORTHWEST;
                    }
                    case SOUTHWEST: {
                        yield DirectionArgument.SOUTHWEST;
                    }
                    case SOUTHEAST: {
                        yield DirectionArgument.SOUTHEAST;
                    }
                }
                yield null;
            }
            case DirectionArgument.LEFT -> {
                switch (DirectionUtils.firstOrdinal(playerFacing)) {
                    case UP: 
                    case DOWN: {
                        throw new Exception("Can't determine direction");
                    }
                    case NORTH: {
                        yield DirectionArgument.WEST;
                    }
                    case EAST: {
                        yield DirectionArgument.NORTH;
                    }
                    case SOUTH: {
                        yield DirectionArgument.EAST;
                    }
                    case WEST: {
                        yield DirectionArgument.SOUTH;
                    }
                    case NORTHWEST: {
                        yield DirectionArgument.SOUTHWEST;
                    }
                    case NORTHEAST: {
                        yield DirectionArgument.NORTHWEST;
                    }
                    case SOUTHEAST: {
                        yield DirectionArgument.NORTHEAST;
                    }
                    case SOUTHWEST: {
                        yield DirectionArgument.SOUTHEAST;
                    }
                }
                yield null;
            }
            case DirectionArgument.RIGHT -> {
                switch (DirectionUtils.firstOrdinal(playerFacing)) {
                    case UP: 
                    case DOWN: {
                        throw new Exception("Can't determine direction");
                    }
                    case NORTH: {
                        yield DirectionArgument.EAST;
                    }
                    case EAST: {
                        yield DirectionArgument.SOUTH;
                    }
                    case SOUTH: {
                        yield DirectionArgument.WEST;
                    }
                    case WEST: {
                        yield DirectionArgument.NORTH;
                    }
                    case NORTHEAST: {
                        yield DirectionArgument.SOUTHEAST;
                    }
                    case NORTHWEST: {
                        yield DirectionArgument.NORTHEAST;
                    }
                    case SOUTHWEST: {
                        yield DirectionArgument.NORTHWEST;
                    }
                    case SOUTHEAST: {
                        yield DirectionArgument.SOUTHWEST;
                    }
                }
                yield null;
            }
            case DirectionArgument.BACK -> {
                switch (DirectionUtils.firstOrdinal(playerFacing)) {
                    case UP: {
                        yield DirectionArgument.DOWN;
                    }
                    case DOWN: {
                        yield DirectionArgument.UP;
                    }
                    case NORTH: {
                        yield DirectionArgument.SOUTH;
                    }
                    case EAST: {
                        yield DirectionArgument.WEST;
                    }
                    case SOUTH: {
                        yield DirectionArgument.NORTH;
                    }
                    case WEST: {
                        yield DirectionArgument.EAST;
                    }
                    case NORTHWEST: {
                        yield DirectionArgument.SOUTHEAST;
                    }
                    case NORTHEAST: {
                        yield DirectionArgument.SOUTHWEST;
                    }
                    case SOUTHEAST: {
                        yield DirectionArgument.NORTHWEST;
                    }
                    case SOUTHWEST: {
                        yield DirectionArgument.NORTHEAST;
                    }
                }
                yield null;
            }
            default -> direction;
        };
    }

    @NotNull
    public static Direction matchDirection(DirectionArgument direction, Direction playerFacing) throws Exception {
        DirectionArgument absoluteDirection = DirectionUtils.relativeToAbsolute(direction, playerFacing);
        return switch (Objects.requireNonNull(absoluteDirection)) {
            case DirectionArgument.NORTH -> Direction.NORTH;
            case DirectionArgument.EAST -> Direction.EAST;
            case DirectionArgument.SOUTH -> Direction.SOUTH;
            case DirectionArgument.WEST -> Direction.WEST;
            case DirectionArgument.NORTHEAST -> Direction.NORTHEAST;
            case DirectionArgument.NORTHWEST -> Direction.NORTHWEST;
            case DirectionArgument.SOUTHEAST -> Direction.SOUTHEAST;
            case DirectionArgument.SOUTHWEST -> Direction.SOUTHWEST;
            case DirectionArgument.UP -> Direction.UP;
            case DirectionArgument.DOWN -> Direction.DOWN;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                yield null;
            }
        };
    }

    public static BlockVector3 directionToBlock(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> BlockVector3.at((int)0, (int)0, (int)-1);
            case Direction.EAST -> BlockVector3.at((int)1, (int)0, (int)0);
            case Direction.SOUTH -> BlockVector3.at((int)0, (int)0, (int)1);
            case Direction.WEST -> BlockVector3.at((int)-1, (int)0, (int)0);
            case Direction.UP -> BlockVector3.at((int)0, (int)1, (int)0);
            case Direction.DOWN -> BlockVector3.at((int)0, (int)-1, (int)0);
            case Direction.NORTHEAST -> BlockVector3.at((int)1, (int)0, (int)-1);
            case Direction.NORTHWEST -> BlockVector3.at((int)-1, (int)0, (int)-1);
            case Direction.SOUTHEAST -> BlockVector3.at((int)1, (int)0, (int)1);
            case Direction.SOUTHWEST -> BlockVector3.at((int)-1, (int)0, (int)1);
            default -> null;
        };
    }
}

