/*
 * Decompiled with CFR 0.152.
 */
package tools.redstone.redstonetools.utils;

import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.lang3.ArrayUtils;

@Environment(value=EnvType.CLIENT)
public class MathUtils {
    public static String handleMat(String exp) {
        String result;
        exp = exp.replaceAll("\\s+", "");
        String[] components = exp.split("(?<=[*+\\-/()^s])|(?=[*+\\-/()^s])");
        try {
            result = MathUtils.calculate(components);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    private static String calculate(String[] components) {
        double result = Double.parseDouble(MathUtils.reduceMathExpression(components));
        if ((double)Math.round(result) == result) {
            return Long.toString((long)result);
        }
        return Double.toString(result);
    }

    private static String reduceMathExpression(String[] components) {
        if (components[0].equals("(")) {
            components = MathUtils.removeAt(components, 0);
            for (int i = 0; i < components.length; ++i) {
                System.out.println(Arrays.toString(components));
                if (components[i].equals("(")) {
                    components = (String[])ArrayUtils.addAll((Object[])Arrays.copyOfRange(components, 0, i), (Object[])new String[]{MathUtils.reduceMathExpression(Arrays.copyOfRange(components, i + 1, components.length))});
                    i = 0;
                }
                if (!components[i].equals(")")) continue;
                components = MathUtils.removeAt(components, i);
            }
        }
        if (components.length == 1) {
            return components[0];
        }
        boolean done = false;
        int loops = 0;
        while (!done) {
            for (int i = 0; i < components.length; ++i) {
                boolean hasMulOrDiv;
                boolean hasExp;
                if (components[i].equals(")")) {
                    components = MathUtils.removeAt(components, i);
                    i = 0;
                    continue;
                }
                if (i != components.length - 1 && components[i + 1].equals("s")) {
                    double stacks = 0.0;
                    double left = 0.0;
                    boolean foundLeft = true;
                    try {
                        stacks = Double.parseDouble(components[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        left = Double.parseDouble(components[i + 2]);
                    }
                    catch (Exception ignored) {
                        foundLeft = false;
                    }
                    components[i] = Double.toString(stacks * 64.0 + left);
                    components = MathUtils.removeAt(components, i + 1);
                    if (foundLeft) {
                        components = MathUtils.removeAt(components, i + 1);
                    }
                    i = 0;
                    continue;
                }
                if (i == 0 || i == components.length - 1) continue;
                if (components[i + 1].equals("(")) {
                    components = (String[])ArrayUtils.addAll((Object[])Arrays.copyOfRange(components, 0, i + 1), (Object[])new String[]{MathUtils.reduceMathExpression(Arrays.copyOfRange(components, i + 1, components.length))});
                    i = 0;
                    continue;
                }
                boolean hasStacks = Arrays.asList(components).contains("s");
                if (hasStacks && (components[i].equals("*") || components[i].equals("+") || components[i].equals("-") || components[i].equals("/") || components[i].equals("^")) || (hasExp = Arrays.asList(components).contains("^")) && (components[i].equals("*") || components[i].equals("+") || components[i].equals("-") || components[i].equals("/")) || (hasMulOrDiv = Arrays.stream(components).anyMatch(s -> s.equals("*") || s.equals("/"))) && (components[i].equals("+") || components[i].equals("-"))) continue;
                double result = MathUtils.getResult(components, i);
                if (!components[i].equals("*") && !components[i].equals("+") && !components[i].equals("-") && !components[i].equals("/") && !components[i].equals("^")) continue;
                components[i - 1] = Double.toString(result);
                components = MathUtils.removeAt(components, i);
                components = MathUtils.removeAt(components, i);
            }
            if (components.length == 1) {
                done = true;
            }
            if (loops > 100000) {
                throw new IllegalArgumentException("Something went wrong!");
            }
            ++loops;
        }
        return components[0];
    }

    private static double getResult(String[] components, int i) {
        double x = 0.0;
        double y = 0.0;
        double result = 0.0;
        if (components[i].equals("*") || components[i].equals("+") || components[i].equals("-") || components[i].equals("/") || components[i].equals("^")) {
            x = Double.parseDouble(components[i - 1]);
            y = Double.parseDouble(components[i + 1]);
        }
        if (components[i].equals("*")) {
            result = x * y;
        }
        if (components[i].equals("+")) {
            result = x + y;
        }
        if (components[i].equals("-")) {
            result = x - y;
        }
        if (components[i].equals("/")) {
            result = x / y;
        }
        if (components[i].equals("^")) {
            result = Math.pow(x, y);
        }
        return result;
    }

    private static String[] removeAt(String[] array, int index) {
        if (index < 0 || index >= array.length) {
            throw new IndexOutOfBoundsException();
        }
        String[] result = new String[array.length - 1];
        int j = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) continue;
            result[j++] = array[i];
        }
        return result;
    }
}

