/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.coloredslimes;

import aquariusplayz.coloredslimes.ColoredParticleOptions;
import aquariusplayz.coloredslimes.ModSetup;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.data.AtlasIds;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ColoredBreakingItemParticle
extends SingleQuadParticle {
    private final float uo;
    private final float vo;

    ColoredBreakingItemParticle(ColoredParticleOptions color, ClientLevel clientLevel, double d, double e, double f, double g, double h, double i, TextureAtlasSprite textureAtlasSprite) {
        this(color, clientLevel, d, e, f, textureAtlasSprite);
        this.xd *= (double)0.1f;
        this.yd *= (double)0.1f;
        this.zd *= (double)0.1f;
        this.xd += g;
        this.yd += h;
        this.zd += i;
        float ff = this.random.nextFloat() * 0.4f + 0.6f;
        Vector3f vector3f = color.getColor();
        this.rCol = this.randomizeColor(vector3f.x(), ff);
        this.gCol = this.randomizeColor(vector3f.y(), ff);
        this.bCol = this.randomizeColor(vector3f.z(), ff);
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TERRAIN;
    }

    protected ColoredBreakingItemParticle(ColoredParticleOptions color, ClientLevel clientLevel, double d, double e, double f, TextureAtlasSprite textureAtlasSprite) {
        super(clientLevel, d, e, f, 0.0, 0.0, 0.0, textureAtlasSprite);
        this.gravity = 1.0f;
        this.quadSize /= 2.0f;
        this.uo = this.random.nextFloat() * 3.0f;
        this.vo = this.random.nextFloat() * 3.0f;
        float ff = this.random.nextFloat() * 0.4f + 0.6f;
        Vector3f vector3f = color.getColor();
        this.rCol = this.randomizeColor(vector3f.x(), ff);
        this.gCol = this.randomizeColor(vector3f.y(), ff);
        this.bCol = this.randomizeColor(vector3f.z(), ff);
    }

    protected float getU0() {
        return this.sprite.getU((this.uo + 1.0f) / 4.0f);
    }

    protected float getU1() {
        return this.sprite.getU(this.uo / 4.0f);
    }

    protected float getV0() {
        return this.sprite.getV(this.vo / 4.0f);
    }

    protected float getV1() {
        return this.sprite.getV((this.vo + 1.0f) / 4.0f);
    }

    protected float randomizeColor(float p_172105_, float p_172106_) {
        return (this.random.nextFloat() * 0.2f + 0.8f) * p_172105_ * p_172106_;
    }

    public static abstract class ItemParticleProvider<T extends ParticleOptions>
    implements ParticleProvider<T> {
        private final ItemStackRenderState scratchRenderState = new ItemStackRenderState();

        protected TextureAtlasSprite getSprite(ItemStack itemStack, ClientLevel clientLevel, RandomSource randomSource) {
            Minecraft.getInstance().getItemModelResolver().updateForTopItem(this.scratchRenderState, itemStack, ItemDisplayContext.GROUND, (Level)clientLevel, (ItemOwner)null, 0);
            TextureAtlasSprite textureAtlasSprite = this.scratchRenderState.pickParticleIcon(randomSource);
            return textureAtlasSprite != null ? textureAtlasSprite : Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(AtlasIds.BLOCKS).missingSprite();
        }
    }

    public static class SlimeProvider
    extends ItemParticleProvider<ColoredParticleOptions> {
        @Nullable
        public Particle createParticle(ColoredParticleOptions ColoredParticleOptions2, ClientLevel clientLevel, double d, double e, double f, double g, double h, double i, RandomSource randomSource) {
            return new ColoredBreakingItemParticle(ColoredParticleOptions2, clientLevel, d, e, f, this.getSprite(new ItemStack((ItemLike)ModSetup.WHITE_SLIME_BALL.get()), clientLevel, randomSource));
        }
    }
}

