/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.coloredslimes;

import aquariusplayz.coloredslimes.ColoredParticleOptions;
import aquariusplayz.coloredslimes.ModSetup;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Vector3f;

public class ColoredBreakingItemParticle
extends TextureSheetParticle {
    private final float uo;
    private final float vo;

    ColoredBreakingItemParticle(ClientLevel p_105646_, double p_105647_, double p_105648_, double p_105649_, double p_105650_, double p_105651_, double p_105652_, ItemStack p_105653_, ColoredParticleOptions color) {
        this(p_105646_, p_105647_, p_105648_, p_105649_, p_105653_, color);
        this.xd *= (double)0.1f;
        this.yd *= (double)0.1f;
        this.zd *= (double)0.1f;
        this.xd += p_105650_;
        this.yd += p_105651_;
        this.zd += p_105652_;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.TERRAIN_SHEET;
    }

    protected ColoredBreakingItemParticle(ClientLevel p_105665_, double p_105666_, double p_105667_, double p_105668_, ItemStack p_105669_, ColoredParticleOptions color) {
        super(p_105665_, p_105666_, p_105667_, p_105668_, 0.0, 0.0, 0.0);
        BakedModel model = Minecraft.getInstance().getItemRenderer().getModel(p_105669_, (Level)p_105665_, null, 0);
        this.setSprite(model.getOverrides().resolve(model, p_105669_, p_105665_, null, 0).getParticleIcon(ModelData.EMPTY));
        this.gravity = 1.0f;
        this.quadSize /= 2.0f;
        this.uo = this.random.nextFloat() * 3.0f;
        this.vo = this.random.nextFloat() * 3.0f;
        float f = this.random.nextFloat() * 0.4f + 0.6f;
        Vector3f vector3f = color.getColor();
        this.rCol = this.randomizeColor(vector3f.x(), f);
        this.gCol = this.randomizeColor(vector3f.y(), f);
        this.bCol = this.randomizeColor(vector3f.z(), f);
    }

    protected float randomizeColor(float p_172105_, float p_172106_) {
        return (this.random.nextFloat() * 0.2f + 0.8f) * p_172105_ * p_172106_;
    }

    protected float getU0() {
        return this.sprite.getU((this.uo + 1.0f) / 4.0f);
    }

    protected float getU1() {
        return this.sprite.getU(this.uo / 4.0f);
    }

    protected float getV0() {
        return this.sprite.getV(this.vo / 4.0f);
    }

    protected float getV1() {
        return this.sprite.getV((this.vo + 1.0f) / 4.0f);
    }

    public static class SlimeProvider
    implements ParticleProvider<ColoredParticleOptions> {
        public Particle createParticle(ColoredParticleOptions color, ClientLevel p_105706_, double p_105707_, double p_105708_, double p_105709_, double p_105710_, double p_105711_, double p_105712_) {
            return new ColoredBreakingItemParticle(p_105706_, p_105707_, p_105708_, p_105709_, new ItemStack((ItemLike)ModSetup.WHITE_SLIME_BALL.get()), color);
        }
    }
}

