/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.difficultylock_common_neoforge.util;

import com.natamus.difficultylock_common_neoforge.config.ConfigHandler;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.world.Difficulty;

public class Util {
    public static int buttonUpdatesLeft = 3;
    public static CycleButton<?> gameModeButton = null;
    public static CycleButton<?> difficultyButton = null;
    public static CycleButton<?> allowCheatsButton = null;
    private static WorldCreationUiState.SelectedGameMode lastSelectedGameMode = null;

    public static void processScreenTick(CreateWorldScreen createWorldScreen) {
        WorldCreationUiState uiState = createWorldScreen.getUiState();
        if (!uiState.getGameMode().equals((Object)lastSelectedGameMode)) {
            buttonUpdatesLeft = 3;
            lastSelectedGameMode = uiState.getGameMode();
        }
        Util.actuallySetDifficulty(createWorldScreen);
    }

    public static Difficulty getDifficultyFromConfig() {
        boolean forceHardcoreMode = ConfigHandler.forceHardcoreMode;
        if (ConfigHandler.forcePeaceful && !forceHardcoreMode) {
            return Difficulty.PEACEFUL;
        }
        if (ConfigHandler.forceEasy && !forceHardcoreMode) {
            return Difficulty.EASY;
        }
        if (ConfigHandler.forceNormal && !forceHardcoreMode) {
            return Difficulty.NORMAL;
        }
        if (ConfigHandler.forceHard || forceHardcoreMode) {
            return Difficulty.HARD;
        }
        return null;
    }

    public static boolean hasADifficultyEnabledInConfig() {
        return ConfigHandler.forcePeaceful || ConfigHandler.forceEasy || ConfigHandler.forceNormal || ConfigHandler.forceHard || ConfigHandler.forceHardcoreMode;
    }

    public static void setCreateWorldScreenDifficulty(Screen screen) {
        Util.delaySettingDifficulty(screen);
    }

    private static void delaySettingDifficulty(final Screen screen) {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                if (screen instanceof CreateWorldScreen) {
                    Util.actuallySetDifficulty((CreateWorldScreen)screen);
                }
            }
        }, 1L);
    }

    private static void actuallySetDifficulty(CreateWorldScreen createWorldScreen) {
        WorldCreationUiState uiState = createWorldScreen.getUiState();
        if (ConfigHandler.forceHardcoreMode) {
            if (!uiState.getGameMode().equals((Object)WorldCreationUiState.SelectedGameMode.HARDCORE)) {
                buttonUpdatesLeft = 3;
                uiState.setGameMode(WorldCreationUiState.SelectedGameMode.HARDCORE);
            }
            if (Util.gameModeButton.active) {
                Util.gameModeButton.active = false;
            }
        } else {
            Difficulty newDifficulty;
            WorldCreationUiState.SelectedGameMode selectedGameMode = uiState.getGameMode();
            if (selectedGameMode.equals((Object)WorldCreationUiState.SelectedGameMode.HARDCORE)) {
                return;
            }
            if (ConfigHandler.disableCreativeModeSelection && selectedGameMode.equals((Object)WorldCreationUiState.SelectedGameMode.CREATIVE)) {
                buttonUpdatesLeft = 3;
                uiState.setGameMode(WorldCreationUiState.SelectedGameMode.SURVIVAL);
                selectedGameMode = WorldCreationUiState.SelectedGameMode.SURVIVAL;
            }
            if ((newDifficulty = Util.getDifficultyFromConfig()) != null && !uiState.getDifficulty().equals((Object)newDifficulty)) {
                buttonUpdatesLeft = 3;
                uiState.setDifficulty(newDifficulty);
            }
            if (Util.difficultyButton.active && Util.hasADifficultyEnabledInConfig()) {
                Util.difficultyButton.active = false;
            }
            if (ConfigHandler.forceCheatsDisabled && selectedGameMode.equals((Object)WorldCreationUiState.SelectedGameMode.SURVIVAL)) {
                if (uiState.isAllowCommands()) {
                    buttonUpdatesLeft = 3;
                    uiState.setAllowCommands(false);
                }
                if (Util.allowCheatsButton.active) {
                    Util.allowCheatsButton.active = false;
                }
            }
        }
    }
}

