/*
 * Decompiled with CFR 0.152.
 */
package nerd.amara;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class Http {
    private static final HttpClient client = HttpClient.newHttpClient();
    private static final Gson gson = new Gson();

    public static <T> T getJson(String url, Class<T> responseType) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                return (T)gson.fromJson(response.body(), responseType);
            }
            System.err.println("HTTP erreur " + response.statusCode() + " sur URL : " + url);
            return null;
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

