/*
 * Decompiled with CFR 0.152.
 */
package nerd.amara;

import java.util.Map;
import java.util.Objects;
import nerd.amara.ConfigManager;
import nerd.amara.ModConfig;
import nerd.amara.tiers.PlayerInfo;
import nerd.amara.tiers.Tier;

public class ShowedTier {
    private static Map<String, Integer> importance = Map.ofEntries(Map.entry("N/A", 0), Map.entry("LT6", 1), Map.entry("HT6", 2), Map.entry("LT5", 3), Map.entry("HT5", 4), Map.entry("LT4", 5), Map.entry("HT4", 6), Map.entry("LT3", 7), Map.entry("HT3", 8), Map.entry("RLT2", 9), Map.entry("LT2", 10), Map.entry("RHT2", 11), Map.entry("HT2", 12), Map.entry("RLT1", 13), Map.entry("LT1", 14), Map.entry("RHT1", 15), Map.entry("HT1", 16));
    private static Map<String, String> tiers_emoji = Map.ofEntries(Map.entry("N/A", ""), Map.entry("LT5", "\uee00"), Map.entry("HT5", "\uee01"), Map.entry("LT4", "\uee02"), Map.entry("HT4", "\uee03"), Map.entry("LT3", "\uee04"), Map.entry("HT3", "\uee05"), Map.entry("LT2", "\uee06"), Map.entry("HT2", "\uee07"), Map.entry("LT1", "\uee08"), Map.entry("HT1", "\uee09"), Map.entry("RLT2", "\uee0a"), Map.entry("RHT2", "\uee0b"), Map.entry("RLT1", "\uee0c"), Map.entry("RHT1", "\uee0d"));
    private static Map<String, String> gamemode_emoji = Map.ofEntries(Map.entry("Mace", "\uef00"), Map.entry("SMP", "\uef01"), Map.entry("UHC", "\uef02"), Map.entry("Pot", "\uef03"), Map.entry("Crystal", "\uef04"), Map.entry("Sword", "\uef05"), Map.entry("DiaSMP", "\uef06"), Map.entry("NethPot", "\uef07"), Map.entry("Axe", "\uef08"));

    public static String showed_tier(PlayerInfo info) {
        Tier element;
        ModConfig config = ConfigManager.getConfig();
        if (Objects.equals(config.gamemode, "Mod Off")) {
            return "";
        }
        if (info == null) {
            return "";
        }
        String best_actual_gamemode = null;
        Integer best_retired_gamemode = null;
        if (!Objects.equals(config.gamemode, "All")) {
            if (info.tiers != null && !Objects.equals(info.tiers.get((Object)config.gamemode).tier, "N/A")) {
                return "\ueeee\ueeee\ueeee\ueeee" + tiers_emoji.get(info.tiers.get((Object)config.gamemode).tier) + gamemode_emoji.get(info.tiers.get((Object)config.gamemode).category);
            }
            if (info.retired_tiers != null) {
                for (int i = 0; i < info.retired_tiers.size(); ++i) {
                    element = info.retired_tiers.get(i);
                    if (!Objects.equals(element.category, config.gamemode)) continue;
                    return "\ueeee\ueeee\ueeee\ueeee" + tiers_emoji.get(info.retired_tiers.get((int)i).tier) + gamemode_emoji.get(info.retired_tiers.get((int)i).category);
                }
            }
        }
        if (info.tiers != null) {
            for (String key : info.tiers.keySet()) {
                Tier value = info.tiers.get(key);
                if (best_actual_gamemode == null & !Objects.equals(info.tiers.get((Object)key).tier, "N/A")) {
                    best_actual_gamemode = key;
                    continue;
                }
                if (Objects.equals(info.tiers.get((Object)key).tier, "N/A") || importance.get(info.tiers.get((Object)best_actual_gamemode).tier) >= importance.get(info.tiers.get((Object)key).tier)) continue;
                best_actual_gamemode = key;
            }
            if (info.retired_tiers != null) {
                for (int i = 0; i < info.retired_tiers.size(); ++i) {
                    element = info.retired_tiers.get(i);
                    if (best_retired_gamemode == null) {
                        best_retired_gamemode = i;
                        continue;
                    }
                    if (importance.get(info.retired_tiers.get((int)best_retired_gamemode.intValue()).tier) >= importance.get(info.retired_tiers.get((int)i).tier)) continue;
                    best_retired_gamemode = i;
                }
            }
            if (best_retired_gamemode != null) {
                if (best_actual_gamemode == null) {
                    return "\ueeee\ueeee\ueeee\ueeee" + tiers_emoji.get(info.retired_tiers.get((int)best_retired_gamemode.intValue()).tier) + gamemode_emoji.get(info.retired_tiers.get((int)best_retired_gamemode.intValue()).category);
                }
                if (importance.get(info.retired_tiers.get((int)best_retired_gamemode.intValue()).tier) > importance.get(info.tiers.get(best_actual_gamemode).tier)) {
                    System.out.println("--------------5" + info.pseudo);
                    return "\ueeee\ueeee\ueeee\ueeee" + tiers_emoji.get(info.retired_tiers.get((int)best_retired_gamemode.intValue()).tier) + gamemode_emoji.get(info.retired_tiers.get((int)best_retired_gamemode.intValue()).category);
                }
            }
            if (best_actual_gamemode != null) {
                return "\ueeee\ueeee\ueeee\ueeee" + tiers_emoji.get(info.tiers.get(best_actual_gamemode).tier) + gamemode_emoji.get(info.tiers.get(best_actual_gamemode).category);
            }
        }
        return "";
    }

    public static String showed_message(PlayerInfo info) {
        Object msg = "";
        msg = (String)msg + "\ued09 FRANCETIERS \ued09\nPLAYER: " + info.pseudo + "\nTOP " + info.global_rank + " (" + info.total_points + " points) \nTIERS:";
        if (info.tiers != null) {
            for (String key : info.tiers.keySet()) {
                Tier value = info.tiers.get(key);
                if (Objects.equals(info.tiers.get((Object)key).tier, "N/A")) continue;
                msg = (String)msg + "\n      " + tiers_emoji.get(value.tier) + " " + gamemode_emoji.get(key) + " " + key;
            }
        } else {
            return "PLAYER UNRANKED";
        }
        if (info.retired_tiers != null) {
            if (!info.retired_tiers.isEmpty()) {
                msg = (String)msg + "\nRETIRED TIERS:";
                for (int i = 0; i < info.retired_tiers.size(); ++i) {
                    Tier element = info.retired_tiers.get(i);
                    msg = (String)msg + "\n      " + tiers_emoji.get(element.tier) + " " + gamemode_emoji.get(element.category) + " " + element.category;
                }
            }
        } else {
            return "PLAYER UNRANKED";
        }
        return msg;
    }
}

