/*
 * Decompiled with CFR 0.152.
 */
package autotree.autotree;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public final class Autotree
extends JavaPlugin
implements Listener {
    private static final Vector[] DIRECTIONS = new Vector[]{new Vector(1, 0, 0), new Vector(-1, 0, 0), new Vector(0, 0, 1), new Vector(0, 0, -1), new Vector(0, 1, 0), new Vector(0, -1, 0)};
    private static final int MAX_BLOCKS = 512;

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public void onDisable() {
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Block start = event.getBlock();
        if (!Tag.LOGS.isTagged((Keyed)start.getType())) {
            return;
        }
        Player player = event.getPlayer();
        List<Block> treeBlocks = this.collectTree(start);
        if (treeBlocks.isEmpty()) {
            return;
        }
        event.setCancelled(true);
        ItemStack tool = player.getInventory().getItemInMainHand();
        for (Block log : treeBlocks) {
            log.breakNaturally(tool, true);
        }
    }

    private List<Block> collectTree(Block start) {
        ArrayList<Block> result = new ArrayList<Block>();
        ArrayDeque<Block> queue = new ArrayDeque<Block>();
        HashSet<Location> visited = new HashSet<Location>();
        queue.add(start);
        visited.add(start.getLocation().toBlockLocation());
        while (!queue.isEmpty() && result.size() < 512) {
            Block current = (Block)queue.poll();
            if (!Tag.LOGS.isTagged((Keyed)current.getType())) continue;
            result.add(current);
            for (Vector direction : DIRECTIONS) {
                Block relative = current.getRelative(direction.getBlockX(), direction.getBlockY(), direction.getBlockZ());
                Location loc = relative.getLocation().toBlockLocation();
                if (visited.contains(loc)) continue;
                visited.add(loc);
                if (!Tag.LOGS.isTagged((Keyed)relative.getType())) continue;
                queue.add(relative);
            }
        }
        return result;
    }
}

