/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff.chunk;

import java.util.HashMap;
import java.util.Map;

public enum AiffChunkType {
    FORMAT_VERSION("FVER"),
    APPLICATION("APPL"),
    SOUND("SSND"),
    COMMON("COMM"),
    COMMENTS("COMT"),
    NAME("NAME"),
    AUTHOR("AUTH"),
    COPYRIGHT("(c) "),
    ANNOTATION("ANNO"),
    TAG("ID3 "),
    CORRUPT_TAG_LATE("D3 \u0000"),
    CORRUPT_TAG_EARLY("\u0000ID3");

    private static final Map<String, AiffChunkType> CODE_TYPE_MAP;
    private String code;

    private AiffChunkType(String code) {
        this.code = code;
    }

    public static synchronized AiffChunkType get(String code) {
        if (CODE_TYPE_MAP.isEmpty()) {
            for (AiffChunkType type : AiffChunkType.values()) {
                CODE_TYPE_MAP.put(type.getCode(), type);
            }
        }
        return CODE_TYPE_MAP.get(code);
    }

    public String getCode() {
        return this.code;
    }

    static {
        CODE_TYPE_MAP = new HashMap<String, AiffChunkType>();
    }
}

