/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.Utils;
import org.jaudiotagger.logging.ErrorMessage;

public class LanguageList
extends Chunk {
    private final List<String> languages = new ArrayList<String>();

    public LanguageList() {
        super(GUID.GUID_LANGUAGE_LIST, 0L, BigInteger.ZERO);
    }

    public LanguageList(long pos, BigInteger size) {
        super(GUID.GUID_LANGUAGE_LIST, pos, size);
    }

    public void addLanguage(String language) {
        if (language.length() < 127) {
            if (!this.languages.contains(language)) {
                this.languages.add(language);
            }
        } else {
            throw new IllegalArgumentException(ErrorMessage.WMA_LENGTH_OF_LANGUAGE_IS_TOO_LARGE.getMsg(language.length() * 2 + 2));
        }
    }

    public String getLanguage(int index) {
        return this.languages.get(index);
    }

    public int getLanguageCount() {
        return this.languages.size();
    }

    public List<String> getLanguages() {
        return new ArrayList<String>(this.languages);
    }

    @Override
    public String prettyPrint(String prefix) {
        StringBuilder result = new StringBuilder(super.prettyPrint(prefix));
        for (int i = 0; i < this.getLanguageCount(); ++i) {
            result.append(prefix);
            result.append("  |-> ");
            result.append(i);
            result.append(" : ");
            result.append(this.getLanguage(i));
            result.append(Utils.LINE_SEPARATOR);
        }
        return result.toString();
    }

    public void removeLanguage(int index) {
        this.languages.remove(index);
    }
}

