/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FullRequestInputStream
extends FilterInputStream {
    public FullRequestInputStream(InputStream source) {
        super(source);
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int off, int len) throws IOException {
        int totalRead = 0;
        while (totalRead < len) {
            int read = super.read(buffer, off + totalRead, len - totalRead);
            if (read >= 0) {
                totalRead += read;
            }
            if (read != -1) continue;
            throw new IOException(len - totalRead + " more bytes expected.");
        }
        return totalRead;
    }

    @Override
    public long skip(long amount) throws IOException {
        long skipped;
        long currSkipped;
        int zeroSkipCnt = 0;
        for (skipped = 0L; skipped < amount && ((currSkipped = super.skip(amount - skipped)) != 0L || ++zeroSkipCnt != 2); skipped += currSkipped) {
        }
        return skipped;
    }
}

