/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;

public class AggregatedFrame
implements TagTextField {
    protected Set<AbstractID3v2Frame> frames = new LinkedHashSet<AbstractID3v2Frame>();

    public void addFrame(AbstractID3v2Frame frame) {
        this.frames.add(frame);
    }

    public Set<AbstractID3v2Frame> getFrames() {
        return this.frames;
    }

    @Override
    public String getContent() {
        StringBuilder sb = new StringBuilder();
        for (AbstractID3v2Frame next : this.frames) {
            sb.append(next.getContent());
        }
        return sb.toString();
    }

    @Override
    public Charset getEncoding() {
        byte textEncoding = this.frames.iterator().next().getBody().getTextEncoding();
        return TextEncoding.getInstanceOf().getCharsetForId(textEncoding);
    }

    @Override
    public void setContent(String content) {
    }

    @Override
    public void setEncoding(Charset encoding) {
    }

    @Override
    public void copyContent(TagField field) {
    }

    @Override
    public String getId() {
        StringBuilder sb = new StringBuilder();
        for (AbstractID3v2Frame next : this.frames) {
            sb.append(next.getId());
        }
        return sb.toString();
    }

    @Override
    public boolean isCommon() {
        return true;
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public void isBinary(boolean b) {
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public byte[] getRawContent() throws UnsupportedEncodingException {
        throw new UnsupportedEncodingException();
    }
}

